/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.net.kyori.adventure.platform.bukkit;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.lone.LoneLibs.chat.Comp;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import lonelibs.net.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import lonelibs.net.kyori.adventure.platform.bukkit.MinecraftReflection;
import lonelibs.net.kyori.adventure.text.Component;
import lonelibs.net.kyori.adventure.text.serializer.ComponentSerializer;
import lonelibs.org.jetbrains.annotations.ApiStatus;
import lonelibs.org.jetbrains.annotations.NotNull;
import lonelibs.org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MinecraftComponentSerializerPatched
implements ComponentSerializer<Component, Component, Object> {
    private static final MinecraftComponentSerializerPatched INSTANCE = new MinecraftComponentSerializerPatched();
    @Nullable
    private static final Class<?> CLASS_JSON_DESERIALIZER = MinecraftReflection.findClass("com.goo".concat("gle.gson.JsonDeserializer"));
    @Nullable
    private static final Class<?> CLASS_CHAT_COMPONENT = MinecraftReflection.findClass(MinecraftReflection.findNmsClassName("IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.Component"));
    private static final AtomicReference<RuntimeException> INITIALIZATION_ERROR = new AtomicReference<UnsupportedOperationException>(new UnsupportedOperationException());
    private static final Gson MC_TEXT_GSON;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE_TREE;
    private static final boolean SUPPORTED;

    public static boolean isSupported() {
        return SUPPORTED;
    }

    @NotNull
    public static MinecraftComponentSerializerPatched get() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull Object input) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        try {
            JsonElement element;
            if (TEXT_SERIALIZER_SERIALIZE_TREE != null) {
                element = TEXT_SERIALIZER_SERIALIZE_TREE.invoke(input);
            } else if (MC_TEXT_GSON != null) {
                element = MC_TEXT_GSON.toJsonTree(input);
            } else {
                return BukkitComponentSerializer.gson().deserialize(TEXT_SERIALIZER_SERIALIZE.invoke(input));
            }
            return BukkitComponentSerializer.gson().serializer().fromJson(element, Component.class);
        }
        catch (Throwable error) {
            throw new UnsupportedOperationException(error);
        }
    }

    @Override
    @NotNull
    public Object serialize(@NotNull Component component) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        if (MC_TEXT_GSON != null) {
            JsonElement json = Comp.componentToJsonTree(component);
            try {
                return MC_TEXT_GSON.fromJson(json, CLASS_CHAT_COMPONENT);
            }
            catch (Throwable error) {
                throw new UnsupportedOperationException(error);
            }
        }
        try {
            return TEXT_SERIALIZER_DESERIALIZE.invoke((String)BukkitComponentSerializer.gson().serialize(component));
        }
        catch (Throwable error) {
            throw new UnsupportedOperationException(error);
        }
    }

    static {
        Gson gson = null;
        MethodHandle textSerializerDeserialize = null;
        MethodHandle textSerializerSerialize = null;
        MethodHandle textSerializerSerializeTree = null;
        try {
            if (CLASS_CHAT_COMPONENT != null) {
                Field gsonField;
                Class<?> chatSerializerClass = Arrays.stream(CLASS_CHAT_COMPONENT.getClasses()).filter(c -> {
                    if (CLASS_JSON_DESERIALIZER != null) {
                        return CLASS_JSON_DESERIALIZER.isAssignableFrom((Class<?>)c);
                    }
                    for (Class<?> itf : c.getInterfaces()) {
                        if (!itf.getSimpleName().equals("JsonDeserializer")) continue;
                        return true;
                    }
                    return false;
                }).findAny().orElse(MinecraftReflection.findNmsClass("ChatSerializer"));
                if (chatSerializerClass != null && (gsonField = (Field)Arrays.stream(chatSerializerClass.getDeclaredFields()).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getType().equals(Gson.class)).findFirst().orElse(null)) != null) {
                    gsonField.setAccessible(true);
                    if (gsonField.get(null) instanceof Gson) {
                        gson = (Gson)gsonField.get(null);
                    }
                }
                ArrayList candidates = new ArrayList();
                if (chatSerializerClass != null) {
                    candidates.add(chatSerializerClass);
                }
                candidates.addAll(Arrays.asList(CLASS_CHAT_COMPONENT.getClasses()));
                for (Class clazz : candidates) {
                    Method[] declaredMethods = clazz.getDeclaredMethods();
                    Method deserialize = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> CLASS_CHAT_COMPONENT.isAssignableFrom(m.getReturnType())).filter(m -> m.getParameterCount() == 1 && m.getParameterTypes()[0].equals(String.class)).min(Comparator.comparing(Method::getName)).orElse(null);
                    Method serialize = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getReturnType().equals(String.class)).filter(m -> m.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(m.getParameterTypes()[0])).findFirst().orElse(null);
                    Method serializeTree = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getReturnType().equals(JsonElement.class)).filter(m -> m.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(m.getParameterTypes()[0])).findFirst().orElse(null);
                    if (deserialize != null) {
                        textSerializerDeserialize = MinecraftReflection.lookup().unreflect(deserialize);
                    }
                    if (serialize != null) {
                        textSerializerSerialize = MinecraftReflection.lookup().unreflect(serialize);
                    }
                    if (serializeTree == null) continue;
                    textSerializerSerializeTree = MinecraftReflection.lookup().unreflect(serializeTree);
                }
            }
        }
        catch (Throwable error) {
            INITIALIZATION_ERROR.set(new UnsupportedOperationException("Error occurred during initialization", error));
        }
        MC_TEXT_GSON = gson;
        TEXT_SERIALIZER_DESERIALIZE = textSerializerDeserialize;
        TEXT_SERIALIZER_SERIALIZE = textSerializerSerialize;
        TEXT_SERIALIZER_SERIALIZE_TREE = textSerializerSerializeTree;
        SUPPORTED = MC_TEXT_GSON != null || TEXT_SERIALIZER_DESERIALIZE != null && TEXT_SERIALIZER_SERIALIZE != null;
    }
}

