/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.dev.lone.fastnbt.nms.nbt;

import dev.lone.fastnbt_benchmark.libs.org.jetbrains.annotations.ApiStatus;
import dev.lone.fastnbt_benchmark.libs.org.jetbrains.annotations.NotNull;
import dev.lone.fastnbt_benchmark.libs.org.jetbrains.annotations.Nullable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import lonelibs.dev.lone.fastnbt.nms.nbt.IListTag;
import lonelibs.dev.lone.fastnbt.nms.nbt.NBT;
import lonelibs.dev.lone.fastnbt.nms.nbt.NCompound;
import lonelibs.dev.lone.fastnbt.nms.nbt.NItem;
import org.bukkit.inventory.ItemStack;

public class NList {
    protected IListTag handler;
    protected Object handle;

    public NList() {
        this(NList.newInstance());
    }

    public NList(Object handle) {
        this.handle = handle;
        this.handler = NBT.list;
    }

    public static Object newInstance() {
        return NBT.list.newNmsInstance();
    }

    public static NList ofItemStackList(List<ItemStack> list) {
        NList nList = new NList(NList.newInstance());
        for (ItemStack e : list) {
            nList.addItemStack(e);
        }
        return nList;
    }

    public static NList ofShortList(List<Short> list) {
        NList nList = new NList(NList.newInstance());
        for (Short e : list) {
            nList.addShort(e);
        }
        return nList;
    }

    public static NList ofIntList(List<Integer> list) {
        NList nList = new NList(NList.newInstance());
        for (Integer e : list) {
            nList.addInt(e);
        }
        return nList;
    }

    public static NList ofIntArrayList(List<int[]> list) {
        NList nList = new NList(NList.newInstance());
        for (int[] e : list) {
            nList.addIntArray(e);
        }
        return nList;
    }

    public static NList ofLongArrayList(List<long[]> list) {
        NList nList = new NList(NList.newInstance());
        for (long[] e : list) {
            nList.addLongArray(e);
        }
        return nList;
    }

    public static NList ofDouble(List<Double> list) {
        NList nList = new NList(NList.newInstance());
        for (Double e : list) {
            nList.addDouble(e);
        }
        return nList;
    }

    public static NList ofFloat(List<Float> list) {
        NList nList = new NList(NList.newInstance());
        for (Float e : list) {
            nList.addFloat(e.floatValue());
        }
        return nList;
    }

    public static NList ofString(List<String> list) {
        NList nList = new NList(NList.newInstance());
        for (String e : list) {
            nList.addString(e);
        }
        return nList;
    }

    public Object getInternal() {
        return this.handle;
    }

    public int size() {
        return this.handler.size(this.handle);
    }

    @ApiStatus.Internal
    public Object getRaw(int i) {
        return this.handler.get(this.handle, i);
    }

    @Nullable
    public NCompound getCompound(int i) {
        Object handle = this.handler.getCompoundAt(this.handle, i);
        if (handle == null) {
            return null;
        }
        return new NCompound(handle);
    }

    public NCompound getOrAddCompound(int i) {
        Object handle = this.handler.getCompoundAt(this.handle, i);
        if (handle != null) {
            return new NCompound(handle);
        }
        return this.addCompound(i);
    }

    @Nullable
    public ItemStack getItemStack(int i) {
        String string = this.getString(i);
        if (string.isEmpty()) {
            return null;
        }
        return NItem.compoundStrToBukkitItem(string);
    }

    @Nullable
    public NList getList(int i) {
        Object handle = this.handler.getListAt(this.handle, i);
        if (handle == null) {
            return null;
        }
        return new NList(handle);
    }

    public NList getOrAddList(int i) {
        Object handle = this.handler.getListAt(this.handle, i);
        if (handle != null) {
            return new NList(handle);
        }
        return this.addList(i);
    }

    public short getByte(int i) {
        return this.handler.getByteAt(this.handle, i);
    }

    public short getShort(int i) {
        return this.handler.getShortAt(this.handle, i);
    }

    public int getInt(int i) {
        return this.handler.getIntAt(this.handle, i);
    }

    public byte @Nullable [] getByteArray(int i) {
        return this.handler.getByteArrayAt(this.handle, i);
    }

    public int @Nullable [] getIntArray(int i) {
        return this.handler.getIntArrayAt(this.handle, i);
    }

    public long @Nullable [] getLongArray(int i) {
        return this.handler.getLongArrayAt(this.handle, i);
    }

    public double getDouble(int i) {
        return this.handler.getDoubleAt(this.handle, i);
    }

    public float getFloat(int i) {
        return this.handler.getFloatAt(this.handle, i);
    }

    public String getString(int i) {
        return this.handler.getStringAt(this.handle, i);
    }

    @ApiStatus.Internal
    private void addRaw(int i, Object any) {
        this.handler.add(this.handle, i, any);
    }

    @ApiStatus.Internal
    protected void addRaw(Object any) {
        this.addRaw(this.size(), any);
    }

    public <N extends NCompound> void addCompound(int i, N nCompound) {
        this.handler.add(this.handle, i, nCompound.handle);
    }

    public <N extends NCompound> void addCompound(N nCompound) {
        this.addCompound(this.size(), nCompound);
    }

    public NCompound addCompound(int i) {
        NCompound wrapped = new NCompound();
        this.addCompound(i, wrapped);
        return wrapped;
    }

    public NCompound addCompound() {
        return this.addCompound(this.size());
    }

    public void addItemStack(int i, ItemStack bukkitItemStack) {
        this.handler.add(this.handle, i, NItem.bukkitItemToNmsCompound(bukkitItemStack));
    }

    public void addItemStack(ItemStack bukkitItemStack) {
        this.addItemStack(this.size(), bukkitItemStack);
    }

    public NList addList(int i, NList list) {
        this.addRaw(i, list.handle);
        return list;
    }

    public NList addList(NList list) {
        this.addRaw(this.size(), list.handle);
        return list;
    }

    public NList addList(int i) {
        NList wrapped = new NList();
        this.addRaw(i, wrapped.handle);
        return wrapped;
    }

    public NList addList() {
        return this.addList(this.size());
    }

    public void addByte(byte value) {
        this.addRaw(value);
    }

    public void addByte(int i, byte value) {
        this.addRaw(i, value);
    }

    public void addShort(short value) {
        this.addRaw(value);
    }

    public void addShort(int i, short value) {
        this.addRaw(i, value);
    }

    public void addInt(int value) {
        this.addRaw(value);
    }

    public void addInt(int i, int value) {
        this.addRaw(i, value);
    }

    public void addLong(long value) {
        this.addRaw(value);
    }

    public void addLong(int i, long value) {
        this.addRaw(i, value);
    }

    public void addFloat(float value) {
        this.addRaw(Float.valueOf(value));
    }

    public void addFloat(int i, float value) {
        this.addRaw(i, Float.valueOf(value));
    }

    public void addDouble(double value) {
        this.addRaw(value);
    }

    public void addDouble(int i, double value) {
        this.addRaw(i, value);
    }

    public void addByteArray(byte[] value) {
        this.addRaw(value);
    }

    public void addByteArray(int i, byte[] value) {
        this.addRaw(i, value);
    }

    public void addString(String value) {
        this.addRaw(value);
    }

    public void addString(int i, String value) {
        this.addRaw(i, value);
    }

    public void addList(List<?> value) {
        this.addRaw(value);
    }

    public void addList(int i, List<?> value) {
        this.addRaw(i, value);
    }

    public void addIntArray(int[] value) {
        this.addRaw(value);
    }

    public void addIntArray(int i, int[] value) {
        this.addRaw(i, value);
    }

    public void addLongArray(long[] value) {
        this.addRaw(value);
    }

    public void addLongArray(int i, long[] value) {
        this.addRaw(i, value);
    }

    @ApiStatus.Internal
    protected void setRaw(int i, Object any) {
        this.handler.set(this.handle, i, any);
    }

    public void setItemStack(int i, ItemStack bukkitItemStack) {
        this.handler.set(this.handle, i, NItem.bukkitItemToNmsCompound(bukkitItemStack));
    }

    public <N extends NCompound> void setCompound(int i, N nCompound) {
        this.handler.set(this.handle, i, nCompound.handle);
    }

    public void setList(int i, List<?> value) {
        this.setRaw(i, value);
    }

    public void setList(int i, NList list) {
        this.addRaw(i, list.handle);
    }

    public void setByte(int i, byte value) {
        this.setRaw(i, value);
    }

    public void setShort(int i, short value) {
        this.setRaw(i, value);
    }

    public void setInt(int i, int value) {
        this.setRaw(i, value);
    }

    public void setLong(int i, long value) {
        this.setRaw(i, value);
    }

    public void setFloat(int i, float value) {
        this.setRaw(i, Float.valueOf(value));
    }

    public void setDouble(int i, double value) {
        this.setRaw(i, value);
    }

    public void setString(int i, String value) {
        this.setRaw(i, value);
    }

    public void setByteArray(int i, byte[] value) {
        this.setRaw(i, value);
    }

    public void setIntArray(int i, int[] value) {
        this.setRaw(i, value);
    }

    public void setLongArray(int i, long[] value) {
        this.setRaw(i, value);
    }

    public Object remove(int i) {
        return this.handler.remove(this.handle, i);
    }

    public String toString() {
        return this.handler.toString();
    }

    public boolean isEmpty() {
        return this.handler.isEmpty(this.handle);
    }

    @NotNull
    public Iterator<NCompound> compoundIterator() {
        return this.iterator(this::getCompound);
    }

    @NotNull
    public Iterator<String> stringIterator() {
        return this.iterator(this::getString);
    }

    @NotNull
    public Iterator<ItemStack> itemIterator() {
        return this.iterator(this::getItemStack);
    }

    @NotNull
    public Iterator<NList> listIterator() {
        return this.iterator(this::getList);
    }

    @NotNull
    public Iterator<Short> shortIterator() {
        return this.iterator(this::getShort);
    }

    @NotNull
    public Iterator<Integer> intIterator() {
        return this.iterator(this::getInt);
    }

    @NotNull
    public Iterator<int[]> intArrayIterator() {
        return this.iterator(this::getIntArray);
    }

    private <Q, R extends Class<Q>> Iterator<Q> iterator(final Function<Integer, Q> consumer) {
        if (this.size() == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<Q>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < NList.this.size();
            }

            @Override
            public Q next() {
                return consumer.apply(this.index++);
            }
        };
    }
}

