/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.dev.lone.fastnbt.nms.nbt;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import dev.lone.fastnbt_benchmark.libs.org.jetbrains.annotations.ApiStatus;
import dev.lone.fastnbt_benchmark.libs.org.jetbrains.annotations.NotNull;
import dev.lone.fastnbt_benchmark.libs.org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lonelibs.dev.lone.fastnbt.nms.nbt.NBT;
import lonelibs.dev.lone.fastnbt.nms.nbt.NBTType;
import lonelibs.dev.lone.fastnbt.nms.nbt.NCompound;
import lonelibs.dev.lone.fastnbt.nms.nbt.NList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class NItem
extends NCompound {
    private boolean isConvertedCopy;
    private ItemStack original;

    public NItem(@NotNull ItemStack itemStack) {
        if (!NBT.isInstanceOfCraftItemStack(itemStack)) {
            this.handle = NBT.item.convertToCraft(itemStack);
            this.original = itemStack;
            this.isConvertedCopy = true;
        } else {
            this.handle = itemStack;
        }
        this.handler = NBT.item;
    }

    @Nullable
    public static NItem of(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return new NItem(itemStack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.handle;
    }

    public void setType(Material type) {
        this.original.setType(type);
        this.refreshCopy();
    }

    public boolean isConvertedCopy() {
        return this.isConvertedCopy;
    }

    public void save() {
        if (this.isConvertedCopy) {
            this.original.setItemMeta(this.getItem().getItemMeta());
        }
    }

    public void refreshCopy() {
        if (this.isConvertedCopy) {
            this.handle = NBT.item.convertToCraft(this.original);
        }
    }

    public static boolean hasNBT(ItemStack itemStack) {
        return NBT.item.hasNBT(itemStack);
    }

    public void merge(ItemStack b) {
        this.merge(new NItem(b));
    }

    public void merge(NItem b) {
        NBT.item.merge((ItemStack)this.handle, (ItemStack)b.handle);
    }

    public boolean merge(String tag) throws JsonSyntaxException {
        if (!NItem.isValidJson(tag)) {
            return false;
        }
        this.merge(this.setNbtByString(tag));
        this.save();
        return true;
    }

    private ItemStack setNbtByString(String nbtTag) {
        ItemStack tmp = new ItemStack(this.getItem().getType());
        Bukkit.getUnsafe().modifyItemStack(tmp, nbtTag);
        return tmp;
    }

    public static boolean isValidJson(String json) {
        try {
            return new JsonParser().parse(json).getAsJsonObject() != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static ItemStack asCraftMirror(ItemStack itemStack) {
        return NBT.item.asCraftMirror(itemStack);
    }

    @Nullable
    public static ItemStack compoundToBukkitItem(NCompound compound) {
        return NBT.item.compoundToItemStack(compound.getInternal());
    }

    @ApiStatus.Internal
    public static Object bukkitItemToNmsItem(ItemStack itemStack) {
        return NBT.item.asNmsCopy(itemStack);
    }

    @ApiStatus.Internal
    public static ItemStack nmsCompoundToBukkitItem(Object internalCompound) {
        return NBT.item.compoundToItemStack(internalCompound);
    }

    @ApiStatus.Internal
    public static Object bukkitItemToNmsCompound(ItemStack itemStack) {
        return NBT.item.itemStackToCompound(itemStack);
    }

    @Nullable
    public static ItemStack compoundStrToBukkitItem(String compoundString) {
        return NBT.item.compoundStrToBukkit(compoundString);
    }

    public static String bukkitItemToCompoundStr(ItemStack bukkitItem) {
        return NBT.item.bukkitItemToCompoundStr(bukkitItem);
    }

    public void setDisplayNameCompound(String compoundString) {
        this.getOrAddCompound("display").setString("Name", compoundString);
    }

    public void setLoreCompounds(List<String> compoundStrings) {
        NCompound display = this.getOrAddCompound("display");
        NList lore = display.getOrAddList("Lore", NBTType.String);
        for (String compound : compoundStrings) {
            lore.addString(compound);
        }
    }

    public void setAttributeModifier(String attributeName, int operation, double amount, String name, String slot, int uuidLeast, int uuidMost) {
        NList attributes = this.getOrAddList("AttributeModifiers", NBTType.Compound);
        NCompound attribute = attributes.addCompound();
        attribute.setString("AttributeName", attributeName);
        attribute.setInt("Operation", operation);
        attribute.setInt("UUIDLeast", uuidLeast);
        attribute.setInt("UUIDMost", uuidMost);
        attribute.setDouble("Amount", amount);
        attribute.setString("Name", name);
        attribute.setString("Slot", slot);
    }

    public void setEnchantment(String id, short level) {
        NList compoundList = this.getOrAddList("Enchantments", NBTType.Compound);
        this.setEnchantment(compoundList, id, level);
    }

    public void addEnchantments(Map<String, Short> enchantments) {
        this.addEnchantments0(enchantments);
    }

    public void setEnchantments(Map<String, Short> enchantments) {
        this.removeEnchantments();
        this.addEnchantments0(enchantments);
    }

    public void removeEnchantments() {
        this.remove("Enchantments");
    }

    public void removeEnchantment(String id) {
        if (!this.hasKey("Enchantments")) {
            return;
        }
        NList compoundList = this.getOrAddList("Enchantments", NBTType.Compound);
        if (!compoundList.isEmpty()) {
            for (int i = 0; i < compoundList.size(); ++i) {
                NCompound enchant = compoundList.getOrAddCompound(i);
                if (!enchant.getString("id").equals(id)) continue;
                compoundList.remove(i);
                return;
            }
        }
    }

    private void addEnchantments0(Map<String, Short> enchantments) {
        NList compoundList = this.getOrAddList("Enchantments", NBTType.Compound);
        for (Map.Entry<String, Short> entry : enchantments.entrySet()) {
            String id = entry.getKey();
            Short level = entry.getValue();
            this.setEnchantment(compoundList, id, level);
        }
    }

    private void setEnchantment(NList compoundList, String id, Short level) {
        if (!compoundList.isEmpty()) {
            for (int i = 0; i < compoundList.size(); ++i) {
                NCompound enchant = compoundList.getOrAddCompound(i);
                if (!enchant.getString("id").equals(id)) continue;
                if (enchant.getShort("lvl") == level.shortValue()) {
                    return;
                }
                enchant.setShort("lvl", level);
                return;
            }
        }
        NCompound enchant = new NCompound();
        compoundList.addCompound(enchant);
        enchant.setString("id", id);
        enchant.setShort("lvl", level);
    }

    public void setSkull(String name, UUID uuid, String value, String signature) {
        this.setType(Material.PLAYER_HEAD);
        NCompound owner = this.getOrAddCompound("SkullOwner");
        owner.setString("Name", name);
        owner.setUUID("Id", uuid);
        NList textures = owner.getOrAddCompound("Properties").getOrAddList("textures", NBTType.Compound);
        NCompound profile = new NCompound();
        textures.addCompound(profile);
        profile.setString("Value", value);
        profile.setString("Signature", signature);
    }

    public void setSkull(String name, String value) {
        this.setType(Material.PLAYER_HEAD);
        NCompound owner = this.getOrAddCompound("SkullOwner");
        owner.setString("Name", name);
        owner.setUUID("Id", UUID.nameUUIDFromBytes(name.getBytes()));
        NList textures = owner.getOrAddCompound("Properties").getOrAddList("textures", NBTType.Compound);
        NCompound profile = new NCompound();
        textures.addCompound(profile);
        profile.setString("Value", value);
    }

    @Nullable
    public String getSkullTextureName() {
        NCompound compound = this.getSkullOwnerCompound();
        if (compound == null) {
            return null;
        }
        String name = compound.getString("Name");
        if ("".equals(name)) {
            return null;
        }
        return name;
    }

    @Nullable
    public UUID getSkullTextureUUID() {
        NCompound compound = this.getSkullOwnerCompound();
        if (compound == null) {
            return null;
        }
        return compound.getUUID("Id");
    }

    @Nullable
    public String getSkullTextureSignature() {
        NCompound compound = this.getSkullTexturesCompound();
        if (compound == null) {
            return null;
        }
        String signature = compound.getString("Signature");
        if ("".equals(signature)) {
            return null;
        }
        return signature;
    }

    @Nullable
    public String getSkullTextureValue() {
        NCompound compound = this.getSkullTexturesCompound();
        if (compound == null) {
            return null;
        }
        String value = compound.getString("Value");
        if ("".equals(value)) {
            return null;
        }
        return value;
    }

    @Nullable
    private NCompound getSkullOwnerCompound() {
        if (!this.hasKey("SkullOwner")) {
            return null;
        }
        return this.getCompound("SkullOwner");
    }

    @Nullable
    private NCompound getSkullTexturesCompound() {
        NCompound compound = this.getSkullOwnerCompound();
        if (compound == null) {
            return null;
        }
        NCompound properties = compound.getCompound("Properties");
        if (properties == null) {
            return null;
        }
        NList textures = properties.getList("textures", NBTType.Compound);
        if (textures == null) {
            return null;
        }
        if (textures.isEmpty()) {
            return null;
        }
        return textures.getOrAddCompound(0);
    }
}

