/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.dev.lone.fastnbt.nms.nbt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lonelibs.dev.lone.fastnbt.nms.nbt.NBT;
import lonelibs.dev.lone.fastnbt.nms.nbt.NCompound;

public class NFile
extends NCompound {
    protected File file;
    private final Lock writeLock;

    public NFile(File file) throws IOException {
        this.file = file;
        if (file == null) {
            throw new NullPointerException("File can't be null!");
        }
        this.writeLock = new ReentrantReadWriteLock().writeLock();
        if (file.exists()) {
            this.handle = NBT.streamTools.read(new FileInputStream(file));
        } else {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            this.handle = NBT.compound.newInstance();
        }
    }

    public File getFile() {
        return this.file;
    }

    public void save() throws IOException {
        try {
            this.writeLock.lock();
            NBT.streamTools.save(this.handle, new FileOutputStream(this.file));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

