/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.dev.lone.fastnbt.nms.nbt;

import dev.lone.fastnbt_benchmark.libs.org.jetbrains.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import lonelibs.dev.lone.fastnbt.Metrics;
import lonelibs.dev.lone.fastnbt.nms.Implementation;
import lonelibs.dev.lone.fastnbt.nms.Version;
import lonelibs.dev.lone.fastnbt.nms.nbt.ICompoundTag;
import lonelibs.dev.lone.fastnbt.nms.nbt.ICraftItemStack;
import lonelibs.dev.lone.fastnbt.nms.nbt.IListTag;
import lonelibs.dev.lone.fastnbt.nms.nbt.INBTIO;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

class NBT {
    public static ICompoundTag compound;
    public static ICraftItemStack item;
    public static IListTag list;
    public static INBTIO streamTools;

    NBT() {
    }

    public static boolean isInstanceOfCraftItemStack(ItemStack itemStack) {
        return item.isInstanceOfCraftItemStack(itemStack);
    }

    private static void initMetrics() {
        try {
            Plugin plugin = NBT.getPlugin();
            if (plugin instanceof JavaPlugin) {
                new Metrics(plugin, 10);
                return;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        Bukkit.getServer().getLogger().info("[FastNBT] Failed to initialize metrics.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected static Plugin getPlugin() {
        ClassLoader classLoader = NBT.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream("plugin.yml");
        if (stream == null) return null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((Reader)reader);
            String name = yaml.getString("name");
            if (name == null) {
                Plugin plugin = null;
                return plugin;
            }
            Plugin plugin = Bukkit.getPluginManager().getPlugin(name);
            return plugin;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static {
        NBT.initMetrics();
        try {
            compound = Implementation.find(ICompoundTag.class, Version.get());
            item = Implementation.find(ICraftItemStack.class, Version.get());
            list = Implementation.find(IListTag.class, Version.get());
            streamTools = Implementation.find(INBTIO.class, Version.get());
        }
        catch (Throwable ex) {
            Bukkit.getLogger().severe("This server is not compatible with FastNBT. Server: " + Bukkit.getVersion() + " (NMS: " + Version.get() + ")");
            ex.printStackTrace();
            Bukkit.shutdown();
        }
    }
}

