/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.dev.lone.fastnbt.nms.nbt;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.lone.fastnbt_benchmark.libs.org.jetbrains.annotations.Nullable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lonelibs.dev.lone.fastnbt.nms.Implementation;
import lonelibs.dev.lone.fastnbt.nms.Version;
import lonelibs.dev.lone.fastnbt.nms.nbt.ICraftItemStack;
import lonelibs.dev.lone.fastnbt.nms.nbt.NBT;
import net.minecraft.server.v1_16_R3.MojangsonParser;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.NBTTagList;
import org.apache.commons.lang.reflect.FieldUtils;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

@Implementation.CyclicDependency(type=ICraftItemStack.class, version=Version.v1_16_R3)
public class CraftItemStack_v1_16_R3
implements ICraftItemStack<NBTTagList, NBTTagCompound, CraftItemStack> {
    public static Field FIELD_HANDLE = FieldUtils.getField(CraftItemStack.class, "handle", true);

    @Override
    public NBTTagCompound newInstance() {
        return new NBTTagCompound();
    }

    @Override
    public CraftItemStack convertToCraft(ItemStack itemStack) {
        if (itemStack instanceof CraftItemStack) {
            return (CraftItemStack)itemStack;
        }
        return CraftItemStack.asCraftCopy((ItemStack)itemStack);
    }

    @Override
    public boolean hasNBT(ItemStack itemStack) {
        if (!NBT.isInstanceOfCraftItemStack(itemStack)) {
            return itemStack != null && itemStack.hasItemMeta();
        }
        net.minecraft.server.v1_16_R3.ItemStack handle = this.getHandle(this.castToCraftItemStack(itemStack));
        if (handle == null) {
            return false;
        }
        return handle.hasTag();
    }

    @Override
    public void merge(ItemStack itemStack, ItemStack otherItem) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        CraftItemStack other = this.castToCraftItemStack(otherItem);
        this.merge(this.getHandle(craftItemStack).getOrCreateTag(), this.getHandle(other).getOrCreateTag());
    }

    @Nullable
    private net.minecraft.server.v1_16_R3.ItemStack getHandle(CraftItemStack craftItemStack) {
        try {
            return (net.minecraft.server.v1_16_R3.ItemStack)FIELD_HANDLE.get(craftItemStack);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private CraftItemStack castToCraftItemStack(ItemStack itemStack) {
        return (CraftItemStack)itemStack;
    }

    @Override
    public void setByte(ItemStack itemStack, String key, byte param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setByte(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setShort(ItemStack itemStack, String key, short param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setShort(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setInt(ItemStack itemStack, String key, int param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setInt(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setLong(ItemStack itemStack, String key, long param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setLong(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setUUID(ItemStack itemStack, String key, UUID param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setUUID(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setFloat(ItemStack itemStack, String key, float param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setFloat(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setDouble(ItemStack itemStack, String key, double param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setDouble(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setString(ItemStack itemStack, String key, String param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setString(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setByteArray(ItemStack itemStack, String key, byte[] param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setByteArray(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setIntArray(ItemStack itemStack, String key, int[] param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setIntArray(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setIntegerList(ItemStack itemStack, String key, List<Integer> param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setIntegerList(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setLongArray(ItemStack itemStack, String key, long[] param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setLongArray(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setLongList(ItemStack itemStack, String key, List<Long> param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setLongList(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public void setBoolean(ItemStack itemStack, String key, boolean param) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.setBoolean(this.getHandle(craftItemStack).getOrCreateTag(), key, param);
    }

    @Override
    public boolean hasKey(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        if (!this.getHandle(craftItemStack).hasTag()) {
            return false;
        }
        return NBT.compound.hasKey(this.getHandle(craftItemStack).getTag(), key);
    }

    @Override
    public boolean hasUUID(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        if (!this.getHandle(craftItemStack).hasTag()) {
            return false;
        }
        return NBT.compound.hasUUID(this.getHandle(craftItemStack).getTag(), key);
    }

    @Override
    @Nullable
    public UUID getUUID(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getUUID(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public byte getByte(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getByte(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public short getShort(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getShort(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public int getInt(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getInt(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public long getLong(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getLong(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public float getFloat(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getFloat(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public double getDouble(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getDouble(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public String getString(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getString(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public byte[] getByteArray(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getByteArray(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public int[] getIntArray(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getIntArray(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public long[] getLongArray(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getLongArray(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public NBTTagCompound getCompound(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return (NBTTagCompound)NBT.compound.getCompound(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public NBTTagCompound getOrAddCompound(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return (NBTTagCompound)NBT.compound.getOrAddCompound(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public NBTTagList getList(ItemStack itemStack, String key, int typeID) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return (NBTTagList)NBT.compound.getList(this.getHandle(craftItemStack).getOrCreateTag(), key, typeID);
    }

    @Override
    public NBTTagList getOrAddList(ItemStack itemStack, String key, int typeID) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return (NBTTagList)NBT.compound.getOrAddList(this.getHandle(craftItemStack).getOrCreateTag(), key, typeID);
    }

    @Override
    public void putTag(ItemStack itemStack, String key, Object value) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        NBT.compound.putTag(this.getHandle(craftItemStack).getOrCreateTag(), key, value);
    }

    @Override
    public boolean getBoolean(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return NBT.compound.getBoolean(this.getHandle(craftItemStack).getOrCreateTag(), key);
    }

    @Override
    public Set<String> getKeys(ItemStack itemStack) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return this.getHandle(craftItemStack).getOrCreateTag().getKeys();
    }

    @Override
    public boolean isEmpty(ItemStack itemStack) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        if (!this.getHandle(craftItemStack).hasTag()) {
            return true;
        }
        return NBT.compound.isEmpty(this.getHandle(craftItemStack).getTag());
    }

    @Override
    public void remove(ItemStack itemStack, String key) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        if (!this.getHandle(craftItemStack).hasTag()) {
            return;
        }
        NBT.compound.remove(this.getHandle(craftItemStack).getTag(), key);
    }

    @Override
    public void merge(NBTTagCompound handle, NBTTagCompound otherHandle) {
        handle.a(otherHandle);
    }

    @Override
    public ItemStack asCraftMirror(ItemStack itemStack) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        return this.getHandle(craftItemStack).asBukkitMirror();
    }

    public net.minecraft.server.v1_16_R3.ItemStack asNmsCopy(ItemStack itemStack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemStack);
    }

    @Override
    public ItemStack compoundToItemStack(NBTTagCompound compound) {
        return net.minecraft.server.v1_16_R3.ItemStack.fromCompound((NBTTagCompound)compound).asBukkitMirror();
    }

    @Override
    public NBTTagCompound itemStackToCompound(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        net.minecraft.server.v1_16_R3.ItemStack nmsCopy = this.asNmsCopy(itemStack);
        nmsCopy.save(nbtTagCompound);
        return nbtTagCompound;
    }

    @Override
    public ItemStack compoundStrToBukkit(String json) {
        try {
            return this.compoundToItemStack(MojangsonParser.parse((String)json));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    @Override
    public boolean isInstanceOfCraftItemStack(ItemStack bukkitItem) {
        return bukkitItem instanceof CraftItemStack;
    }

    @Override
    public String toString(ItemStack itemStack) {
        CraftItemStack craftItemStack = this.castToCraftItemStack(itemStack);
        net.minecraft.server.v1_16_R3.ItemStack handle = this.getHandle(craftItemStack);
        if (handle == null || !handle.hasTag()) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        handle.save(nbt);
        return NBT.compound.toString(nbt);
    }
}

