/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.dev.lone.fastnbt.nms;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import lonelibs.dev.lone.fastnbt.nms.Version;
import org.bukkit.Bukkit;

public abstract class Implementation {
    private static final String basePackageNonObf = Implementation.class.getPackageName();

    public static <IType> IType find(Class<IType> type, Version version) {
        HashMap cache = new HashMap();
        for (Class<?> clazz : Implementation.listAllClasses()) {
            if (!clazz.isAnnotationPresent(CyclicDependency.class)) continue;
            CyclicDependency annotation = clazz.getAnnotation(CyclicDependency.class);
            cache.put(clazz, annotation);
        }
        Class implClass = Implementation.findInCache(cache, type, version);
        if (implClass != null) {
            return (IType)Implementation.newInstance(implClass);
        }
        Version[] versions = Version.values();
        for (int i = version.ordinal(); i >= 0; --i) {
            implClass = Implementation.findInCache(cache, type, versions[i]);
            if (implClass == null) continue;
            return (IType)Implementation.newInstance(implClass);
        }
        throw new RuntimeException("This server is not compatible with this plugin.");
    }

    private static <ImplType> ImplType newInstance(Class<ImplType> implClass) {
        try {
            return implClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            Bukkit.getLogger().severe("FastNBT failed to instantiate nms wrapper");
            throw new RuntimeException(e);
        }
    }

    private static <ImplType, IType> Class<ImplType> findInCache(Map<Class<?>, CyclicDependency> cache, Class<IType> type, Version version) {
        Class<?> implementationClass = null;
        for (Map.Entry<Class<?>, CyclicDependency> entry : cache.entrySet()) {
            Class<?> clazz = entry.getKey();
            CyclicDependency annotation = entry.getValue();
            if (!type.equals(annotation.type()) || annotation.version() != version) continue;
            implementationClass = clazz;
        }
        return implementationClass;
    }

    private static List<Class<?>> listAllClasses() {
        return Implementation.findClassesInPackage(null);
    }

    private static List<Class<?>> findClassesInPackage(@Nullable String packageName) {
        ArrayList classes = new ArrayList();
        ClassLoader classLoader = Implementation.class.getClassLoader();
        CodeSource src = Implementation.class.getProtectionDomain().getCodeSource();
        if (src == null) {
            return classes;
        }
        URL jar = src.getLocation();
        try {
            ZipEntry entry;
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                name = name.replace("\\", ".").replace("/", ".").replace(".class", "");
                if (packageName != null && !name.startsWith(packageName) || !name.startsWith(basePackageNonObf + ".")) continue;
                try {
                    classes.add(classLoader.loadClass(name));
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return classes;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface CyclicDependency {
        public Class<?> type();

        public Version version();
    }
}

