/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.jayway.jsonpath.internal.filter;

import java.util.Locale;
import lonelibs.com.jayway.jsonpath.InvalidPathException;

public enum RelationalOperator {
    GTE(">="),
    LTE("<="),
    EQ("=="),
    TSEQ("==="),
    NE("!="),
    TSNE("!=="),
    LT("<"),
    GT(">"),
    REGEX("=~"),
    NIN("NIN"),
    IN("IN"),
    CONTAINS("CONTAINS"),
    ALL("ALL"),
    SIZE("SIZE"),
    EXISTS("EXISTS"),
    TYPE("TYPE"),
    MATCHES("MATCHES"),
    EMPTY("EMPTY"),
    SUBSETOF("SUBSETOF"),
    ANYOF("ANYOF"),
    NONEOF("NONEOF");

    private final String operatorString;

    private RelationalOperator(String operatorString) {
        this.operatorString = operatorString;
    }

    public static RelationalOperator fromString(String operatorString) {
        String upperCaseOperatorString = operatorString.toUpperCase(Locale.ROOT);
        for (RelationalOperator operator : RelationalOperator.values()) {
            if (!operator.operatorString.equals(upperCaseOperatorString)) continue;
            return operator;
        }
        throw new InvalidPathException("Filter operator " + operatorString + " is not supported!");
    }

    public String toString() {
        return this.operatorString;
    }
}

