/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.Function;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.codec.DateTimeCodec;
import lonelibs.com.alibaba.fastjson2.writer.ObjectWriter;

final class ObjectWriterImplZonedDateTime
extends DateTimeCodec
implements ObjectWriter {
    static final ObjectWriterImplZonedDateTime INSTANCE = new ObjectWriterImplZonedDateTime(null, null);
    private final Function function;

    public ObjectWriterImplZonedDateTime(String format, Locale locale) {
        this(format, locale, null);
    }

    public ObjectWriterImplZonedDateTime(String format, Locale locale, Function function) {
        super(format, locale);
        this.function = function;
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        jsonWriter.writeZonedDateTime((ZonedDateTime)object);
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        DateTimeFormatter formatter;
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        ZonedDateTime zdt = this.function != null ? (ZonedDateTime)this.function.apply(object) : (ZonedDateTime)object;
        JSONWriter.Context ctx = jsonWriter.context;
        if (this.formatUnixTime || this.format == null && ctx.isDateFormatUnixTime()) {
            long millis = zdt.toInstant().toEpochMilli();
            jsonWriter.writeInt64(millis / 1000L);
            return;
        }
        if (this.formatMillis || this.format == null && ctx.isDateFormatMillis()) {
            jsonWriter.writeInt64(zdt.toInstant().toEpochMilli());
            return;
        }
        int year = zdt.getYear();
        if (year >= 0 && year <= 9999) {
            if (this.formatISO8601 || ctx.isDateFormatISO8601()) {
                jsonWriter.writeDateTimeISO8601(year, zdt.getMonthValue(), zdt.getDayOfMonth(), zdt.getHour(), zdt.getMinute(), zdt.getSecond(), zdt.getNano() / 1000000, zdt.getOffset().getTotalSeconds(), true);
                return;
            }
            if (this.yyyyMMddhhmmss19) {
                jsonWriter.writeDateTime19(year, zdt.getMonthValue(), zdt.getDayOfMonth(), zdt.getHour(), zdt.getMinute(), zdt.getSecond());
                return;
            }
            if (this.yyyyMMddhhmmss14) {
                jsonWriter.writeDateTime14(year, zdt.getMonthValue(), zdt.getDayOfMonth(), zdt.getHour(), zdt.getMinute(), zdt.getSecond());
                return;
            }
        }
        if ((formatter = this.getDateFormatter()) == null) {
            formatter = ctx.getDateFormatter();
        }
        if (formatter == null) {
            jsonWriter.writeZonedDateTime(zdt);
            return;
        }
        String str = formatter.format(zdt);
        jsonWriter.writeString(str);
    }
}

