/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Type;
import lonelibs.com.alibaba.fastjson2.JSONB;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.util.Fnv;
import lonelibs.com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;

final class ObjectWriterImplInt8Array
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplInt8Array INSTANCE = new ObjectWriterImplInt8Array();
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[Byte");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[Byte");

    ObjectWriterImplInt8Array() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        Byte[] array = (Byte[])object;
        jsonWriter.startArray();
        for (int i = 0; i < array.length; ++i) {
            Byte value;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((value = array[i]) == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeInt32(value.byteValue());
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        Byte[] array = (Byte[])object;
        jsonWriter.startArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            Byte value = array[i];
            if (value == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeInt32(value.byteValue());
        }
    }
}

