/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Type;
import lonelibs.com.alibaba.fastjson2.JSONB;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.util.Fnv;
import lonelibs.com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;

final class ObjectWriterImplInt64Array
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplInt64Array INSTANCE = new ObjectWriterImplInt64Array();
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[Long");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[Long");

    ObjectWriterImplInt64Array() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            if (jsonWriter.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) {
                jsonWriter.startArray();
                jsonWriter.endArray();
            } else {
                jsonWriter.writeNull();
            }
            return;
        }
        Long[] array = (Long[])object;
        jsonWriter.startArray();
        for (int i = 0; i < array.length; ++i) {
            Long item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = array[i]) == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeInt64(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        Long[] array = (Long[])object;
        jsonWriter.startArray(array.length);
        for (Long item : array) {
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeInt64(item);
        }
    }
}

