/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Type;
import java.text.DecimalFormat;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;

final class ObjectWriterImplFloat
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplFloat INSTANCE = new ObjectWriterImplFloat(null);
    private final DecimalFormat format;

    public ObjectWriterImplFloat(DecimalFormat format) {
        this.format = format;
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeFloat(((Float)object).floatValue());
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (this.format != null) {
            String str = this.format.format(object);
            jsonWriter.writeRaw(str);
            return;
        }
        jsonWriter.writeFloat(((Float)object).floatValue());
        long features2 = jsonWriter.getFeatures(features);
        if ((features2 & JSONWriter.Feature.WriteClassName.mask) != 0L && (features2 & JSONWriter.Feature.WriteNonStringKeyAsString.mask) == 0L && (features2 & JSONWriter.Feature.NotWriteNumberClassName.mask) == 0L && fieldType != Float.class && fieldType != Float.TYPE) {
            jsonWriter.writeRaw('F');
        }
    }
}

