/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.codec.DateTimeCodec;
import lonelibs.com.alibaba.fastjson2.util.DateUtils;
import lonelibs.com.alibaba.fastjson2.writer.ObjectWriter;

final class ObjectWriterImplDate
extends DateTimeCodec
implements ObjectWriter {
    static final ObjectWriterImplDate INSTANCE = new ObjectWriterImplDate(null, null);
    static final char[] PREFIX_CHARS = "new Date(".toCharArray();
    static final byte[] PREFIX_BYTES = "new Date(".getBytes(StandardCharsets.UTF_8);
    static final char[] PREFIX_CHARS_SQL = "{\"@type\":\"java.sql.Date\",\"val\":".toCharArray();
    static final byte[] PREFIX_BYTES_SQL = "{\"@type\":\"java.sql.Date\",\"val\":".getBytes(StandardCharsets.UTF_8);

    public ObjectWriterImplDate(String format, Locale locale) {
        super(format, locale);
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeMillis(((Date)object).getTime());
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        String dateFormat;
        boolean formatISO8601;
        int offsetSeconds;
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        JSONWriter.Context ctx = jsonWriter.context;
        Date date = (Date)object;
        long millis = date.getTime();
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            char end = ')';
            if (jsonWriter.utf16) {
                char[] prefix;
                if ("java.sql.Date".equals(date.getClass().getName())) {
                    prefix = PREFIX_CHARS_SQL;
                    end = '}';
                } else {
                    prefix = PREFIX_CHARS;
                }
                jsonWriter.writeRaw(prefix, 0, prefix.length);
            } else {
                byte[] prefix;
                if ("java.sql.Date".equals(date.getClass().getName())) {
                    prefix = PREFIX_BYTES_SQL;
                    end = '}';
                } else {
                    prefix = PREFIX_BYTES;
                }
                jsonWriter.writeRaw(prefix);
            }
            jsonWriter.writeInt64(millis);
            jsonWriter.writeRaw(end);
            return;
        }
        if (this.formatMillis || this.format == null && ctx.isDateFormatMillis()) {
            jsonWriter.writeInt64(millis);
            return;
        }
        if (this.formatUnixTime || this.format == null && ctx.isDateFormatUnixTime()) {
            jsonWriter.writeInt64(millis / 1000L);
            return;
        }
        ZoneId zoneId = ctx.getZoneId();
        if (zoneId == DateUtils.SHANGHAI_ZONE_ID || zoneId.getRules() == DateUtils.SHANGHAI_ZONE_RULES) {
            offsetSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(Math.floorDiv(millis, 1000L));
        } else if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            offsetSeconds = 0;
        } else {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneId);
            offsetSeconds = zdt.getOffset().getTotalSeconds();
        }
        boolean bl = formatISO8601 = this.formatISO8601 || ctx.isDateFormatISO8601();
        if (formatISO8601) {
            dateFormat = null;
        } else {
            dateFormat = this.format;
            if (dateFormat == null) {
                dateFormat = ctx.getDateFormat();
            }
        }
        if (dateFormat == null) {
            long yearEst;
            long doyEst;
            int offsetTotalSeconds;
            int SECONDS_PER_DAY = 86400;
            long epochSecond = Math.floorDiv(millis, 1000L);
            if (zoneId == DateUtils.SHANGHAI_ZONE_ID || zoneId.getRules() == DateUtils.SHANGHAI_ZONE_RULES) {
                offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
            } else {
                Instant instant = Instant.ofEpochMilli(millis);
                offsetTotalSeconds = zoneId.getRules().getOffset(instant).getTotalSeconds();
            }
            long localSecond = epochSecond + (long)offsetTotalSeconds;
            long localEpochDay = Math.floorDiv(localSecond, 86400L);
            int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
            int DAYS_PER_CYCLE = 146097;
            long DAYS_0000_TO_1970 = 719528L;
            long zeroDay = localEpochDay + 719528L;
            long adjust = 0L;
            if ((zeroDay -= 60L) < 0L) {
                long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
                adjust = adjustCycles * 400L;
                zeroDay += -adjustCycles * 146097L;
            }
            if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
                doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
            }
            yearEst += adjust;
            int marchDoy0 = (int)doyEst;
            int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
            int month = (marchMonth0 + 2) % 12 + 1;
            int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
            if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
                throw new DateTimeException("Invalid year " + yearEst);
            }
            int year = (int)yearEst;
            int MINUTES_PER_HOUR = 60;
            int SECONDS_PER_MINUTE = 60;
            int SECONDS_PER_HOUR = 3600;
            long secondOfDay = secsOfDay;
            if (secondOfDay < 0L || secondOfDay > 86399L) {
                throw new DateTimeException("Invalid secondOfDay " + secondOfDay);
            }
            int hours = (int)(secondOfDay / 3600L);
            int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
            int hour = hours;
            int minute = minutes;
            int second = (int)(secondOfDay -= (long)(minutes * 60));
            if (year >= 0 && year <= 9999) {
                int mos = (int)Math.floorMod(millis, 1000L);
                if (mos == 0 && !formatISO8601) {
                    if (hour == 0 && minute == 0 && second == 0 && "java.sql.Date".equals(date.getClass().getName())) {
                        jsonWriter.writeDateYYYMMDD10(year, month, dayOfMonth);
                    } else {
                        jsonWriter.writeDateTime19(year, month, dayOfMonth, hour, minute, second);
                    }
                } else {
                    jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, mos, offsetSeconds, formatISO8601);
                }
                return;
            }
        }
        DateTimeFormatter formatter = this.format != null ? this.getDateFormatter() : ctx.getDateFormatter();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneId);
        String str = formatter.format(zdt);
        jsonWriter.writeString(str);
    }
}

