/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.function.ToFloatFunction;
import lonelibs.com.alibaba.fastjson2.writer.FieldWriter;

final class FieldWriterFloatValueFunc
extends FieldWriter {
    final ToFloatFunction function;

    FieldWriterFloatValueFunc(String fieldName, int ordinal, long features, String format, String label, Field field, Method method, ToFloatFunction function) {
        super(fieldName, ordinal, features, format, label, Float.TYPE, Float.TYPE, field, method);
        this.function = function;
    }

    public Object getFieldValue(Object object) {
        return Float.valueOf(this.function.applyAsFloat(object));
    }

    public void writeValue(JSONWriter jsonWriter, Object object) {
        float fieldValue = this.function.applyAsFloat(object);
        if (this.decimalFormat != null) {
            jsonWriter.writeDouble(fieldValue, this.decimalFormat);
        } else {
            jsonWriter.writeDouble(fieldValue);
        }
    }

    public boolean write(JSONWriter jsonWriter, Object object) {
        float value;
        try {
            value = this.function.applyAsFloat(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        this.writeFieldName(jsonWriter);
        if (this.decimalFormat != null) {
            jsonWriter.writeFloat(value, this.decimalFormat);
        } else {
            jsonWriter.writeFloat(value);
        }
        return true;
    }
}

