/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.util.JDKUtils;
import lonelibs.com.alibaba.fastjson2.writer.FieldWriter;

class FieldWriterDoubleField<T>
extends FieldWriter<T> {
    protected FieldWriterDoubleField(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, label, (Type)((Object)Double.class), Double.class, field, null);
    }

    @Override
    public Object getFieldValue(Object object) {
        if (object == null) {
            throw new JSONException("field.get error, " + this.fieldName);
        }
        try {
            Object value = this.fieldOffset != -1L && !this.fieldClass.isPrimitive() ? JDKUtils.UNSAFE.getObject(object, this.fieldOffset) : this.field.get(object);
            return value;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Double value = (Double)this.getFieldValue((Object)object);
        if (value == null) {
            long features = jsonWriter.getFeatures(this.features);
            if ((features & JSONWriter.Feature.WriteNulls.mask) != 0L && (features & JSONWriter.Feature.NotWriteDefaultValue.mask) == 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeNumberNull();
                return true;
            }
            return false;
        }
        this.writeFieldName(jsonWriter);
        double doubleValue = value;
        if (this.decimalFormat != null) {
            jsonWriter.writeDouble(doubleValue, this.decimalFormat);
        } else {
            jsonWriter.writeDouble(doubleValue);
        }
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Double value = (Double)this.getFieldValue((Object)object);
        if (value == null) {
            jsonWriter.writeNumberNull();
        } else {
            double doubleValue = value;
            if (this.decimalFormat != null) {
                jsonWriter.writeDouble(doubleValue, this.decimalFormat);
            } else {
                jsonWriter.writeDouble(doubleValue);
            }
        }
    }
}

