/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.function.Function;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.writer.FieldWriterDate;

final class FieldWriterDateFunc<T>
extends FieldWriterDate<T> {
    final Function<T, Date> function;

    FieldWriterDateFunc(String fieldName, int ordinal, long features, String dateTimeFormat, String label, Field field, Method method, Function<T, Date> function) {
        super(fieldName, ordinal, features, dateTimeFormat, label, (Type)((Object)Date.class), Date.class, field, method);
        this.function = function;
    }

    @Override
    public Object getFieldValue(T object) {
        return this.function.apply(object);
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Date value = this.function.apply(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        this.writeDate(jsonWriter, false, value.getTime());
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Date value = this.function.apply(object);
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & JSONWriter.Feature.WriteNulls.mask) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeNull();
                return true;
            }
            return false;
        }
        this.writeDate(jsonWriter, value.getTime());
        return true;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }
}

