/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.writer.FieldWriter;

final class FieldWriterBigDecimalMethod<T>
extends FieldWriter<T> {
    FieldWriterBigDecimalMethod(String fieldName, int ordinal, long features, String format, String label, Field field, Method method) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)BigDecimal.class), BigDecimal.class, null, method);
    }

    @Override
    public Object getFieldValue(T object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke getter method error, " + this.fieldName, e);
        }
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        BigDecimal value = (BigDecimal)this.getFieldValue(object);
        jsonWriter.writeDecimal(value, this.features, this.decimalFormat);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long features;
        BigDecimal value;
        try {
            value = (BigDecimal)this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null && ((features = this.features | jsonWriter.getFeatures()) & JSONWriter.Feature.WriteNulls.mask) == 0L) {
            return false;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeDecimal(value, this.features, this.decimalFormat);
        return true;
    }
}

