/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.writer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.function.Function;
import lonelibs.com.alibaba.fastjson2.JSONWriter;
import lonelibs.com.alibaba.fastjson2.writer.FieldWriter;

final class FieldWriterBigDecimalFunc<T>
extends FieldWriter<T> {
    final Function<T, BigDecimal> function;

    FieldWriterBigDecimalFunc(String fieldName, int ordinal, long features, String format, String label, Field field, Method method, Function<T, BigDecimal> function) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)BigDecimal.class), BigDecimal.class, null, method);
        this.function = function;
    }

    @Override
    public Object getFieldValue(T object) {
        return this.function.apply(object);
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        BigDecimal value = this.function.apply(object);
        jsonWriter.writeDecimal(value, this.features, this.decimalFormat);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long features;
        BigDecimal value;
        try {
            value = this.function.apply(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null && ((features = this.features | jsonWriter.getFeatures()) & JSONWriter.Feature.WriteNulls.mask) == 0L) {
            return false;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeDecimal(value, this.features, this.decimalFormat);
        return true;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }
}

