/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.reader;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.Supplier;
import lonelibs.com.alibaba.fastjson2.JSONArray;
import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONObject;
import lonelibs.com.alibaba.fastjson2.JSONReader;
import lonelibs.com.alibaba.fastjson2.reader.ObjectReader;
import lonelibs.com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import lonelibs.com.alibaba.fastjson2.util.GuavaSupport;
import lonelibs.com.alibaba.fastjson2.util.MapMultiValueType;
import lonelibs.com.alibaba.fastjson2.util.TypeUtils;

public class ObjectReaderImplMapMultiValueType
implements ObjectReader {
    final Class mapType;
    final Class instanceType;
    final Function builder;
    final MapMultiValueType multiValueType;

    public ObjectReaderImplMapMultiValueType(MapMultiValueType multiValueType) {
        this.multiValueType = multiValueType;
        this.mapType = multiValueType.getMapType();
        Class instanceType = this.mapType;
        Function<Map, Map> builder = null;
        if (this.mapType == Map.class || this.mapType == AbstractMap.class || this.mapType == ObjectReaderImplMap.CLASS_SINGLETON_MAP) {
            instanceType = HashMap.class;
        } else if (this.mapType == ObjectReaderImplMap.CLASS_UNMODIFIABLE_MAP) {
            instanceType = LinkedHashMap.class;
        } else if (this.mapType == SortedMap.class || this.mapType == ObjectReaderImplMap.CLASS_UNMODIFIABLE_SORTED_MAP || this.mapType == ObjectReaderImplMap.CLASS_UNMODIFIABLE_NAVIGABLE_MAP) {
            instanceType = TreeMap.class;
        } else if (this.mapType == ConcurrentMap.class) {
            instanceType = ConcurrentHashMap.class;
        } else if (this.mapType == ConcurrentNavigableMap.class) {
            instanceType = ConcurrentSkipListMap.class;
        } else {
            switch (this.mapType.getTypeName()) {
                case "com.google.common.collect.ImmutableMap": 
                case "com.google.common.collect.RegularImmutableMap": {
                    instanceType = HashMap.class;
                    builder = GuavaSupport.immutableMapConverter();
                    break;
                }
                case "com.google.common.collect.SingletonImmutableBiMap": {
                    instanceType = HashMap.class;
                    builder = GuavaSupport.singletonBiMapConverter();
                    break;
                }
                case "java.util.Collections$SynchronizedMap": {
                    instanceType = HashMap.class;
                    builder = Collections::synchronizedMap;
                    break;
                }
                case "java.util.Collections$SynchronizedNavigableMap": {
                    instanceType = TreeMap.class;
                    builder = Collections::synchronizedNavigableMap;
                    break;
                }
                case "java.util.Collections$SynchronizedSortedMap": {
                    instanceType = TreeMap.class;
                    builder = Collections::synchronizedSortedMap;
                    break;
                }
            }
        }
        this.instanceType = instanceType;
        this.builder = builder;
    }

    public Object createInstance(long features) {
        if (this.instanceType != null && !this.instanceType.isInterface()) {
            try {
                return this.instanceType.newInstance();
            }
            catch (Exception e) {
                throw new JSONException("create map error", e);
            }
        }
        return new HashMap();
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Map<String, Object> object;
        if (!jsonReader.nextIfObjectStart()) {
            if (jsonReader.nextIfNullOrEmptyString()) {
                return null;
            }
            throw new JSONException(jsonReader.info("expect '{', but '" + jsonReader.current() + "'"));
        }
        JSONReader.Context context = jsonReader.getContext();
        long contextFeatures = context.getFeatures() | features;
        Map innerMap = null;
        if (this.instanceType == HashMap.class) {
            Supplier<Map> objectSupplier = context.getObjectSupplier();
            if (this.mapType == Map.class && objectSupplier != null) {
                object = objectSupplier.get();
                innerMap = TypeUtils.getInnerMap(object);
            } else {
                object = new HashMap();
            }
        } else {
            object = this.instanceType == JSONObject.class ? new JSONObject() : (Map)this.createInstance(contextFeatures);
        }
        Type valueType = null;
        int i = 0;
        while (!jsonReader.nextIfObjectEnd() && !jsonReader.isEnd()) {
            Object origin;
            Object value;
            String name;
            if (jsonReader.nextIfNull()) {
                if (!jsonReader.nextIfMatch(':')) {
                    throw new JSONException(jsonReader.info("illegal json"));
                }
                name = null;
            } else {
                name = jsonReader.readFieldName();
                valueType = this.multiValueType.getType(name);
            }
            if (valueType == null) {
                value = jsonReader.readAny();
            } else {
                ObjectReader valueObjectReader = jsonReader.getObjectReader(valueType);
                value = valueObjectReader.readObject(jsonReader, valueType, fieldName, 0L);
            }
            if ((value != null || (contextFeatures & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = innerMap != null ? innerMap.put(name, value) : object.put(name, value)) != null && (contextFeatures & JSONReader.Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                if (origin instanceof Collection) {
                    ((Collection)origin).add(value);
                    object.put(name, origin);
                } else {
                    JSONArray array = JSONArray.of(origin, value);
                    object.put(name, array);
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }
}

