/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.reader;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Map;
import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONReader;
import lonelibs.com.alibaba.fastjson2.reader.ObjectReader;
import lonelibs.com.alibaba.fastjson2.reader.ObjectReaderPrimitive;

class ObjectReaderImplMapEntry
extends ObjectReaderPrimitive {
    final Type keyType;
    final Type valueType;
    volatile ObjectReader keyReader;
    volatile ObjectReader valueReader;

    public ObjectReaderImplMapEntry(Type keyType, Type valueType) {
        super(Map.Entry.class);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Object value;
        Object key;
        int entryCnt = jsonReader.startArray();
        if (entryCnt != 2) {
            throw new JSONException(jsonReader.info("entryCnt must be 2, but " + entryCnt));
        }
        if (this.keyType == null) {
            key = jsonReader.readAny();
        } else {
            if (this.keyReader == null) {
                this.keyReader = jsonReader.getObjectReader(this.keyType);
            }
            key = this.keyReader.readObject(jsonReader, fieldType, fieldName, features);
        }
        if (this.valueType == null) {
            value = jsonReader.readAny();
        } else {
            if (this.valueReader == null) {
                this.valueReader = jsonReader.getObjectReader(this.valueType);
            }
            value = this.valueReader.readObject(jsonReader, fieldType, fieldName, features);
        }
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }

    @Override
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Object value;
        jsonReader.nextIfObjectStart();
        Object key = jsonReader.readAny();
        jsonReader.nextIfMatch(':');
        if (this.valueType == null) {
            value = jsonReader.readAny();
        } else {
            if (this.valueReader == null) {
                this.valueReader = jsonReader.getObjectReader(this.valueType);
            }
            value = this.valueReader.readObject(jsonReader, fieldType, fieldName, features);
        }
        jsonReader.nextIfObjectEnd();
        jsonReader.nextIfComma();
        return new AbstractMap.SimpleEntry<Object, Object>(key, value);
    }
}

