/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.reader;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import lonelibs.com.alibaba.fastjson2.JSONReader;
import lonelibs.com.alibaba.fastjson2.codec.DateTimeCodec;
import lonelibs.com.alibaba.fastjson2.reader.ObjectReader;

class ObjectReaderImplLocalTime
extends DateTimeCodec
implements ObjectReader {
    static final ObjectReaderImplLocalTime INSTANCE = new ObjectReaderImplLocalTime(null, null);

    public ObjectReaderImplLocalTime(String format, Locale locale) {
        super(format, locale);
    }

    public Class getObjectClass() {
        return LocalTime.class;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return jsonReader.readLocalTime();
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        JSONReader.Context context = jsonReader.getContext();
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.isInt()) {
            long millis = jsonReader.readInt64Value();
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            ZoneId zoneId = context.getZoneId();
            return LocalDateTime.ofInstant(instant, zoneId).toLocalTime();
        }
        if (this.format == null || jsonReader.isNumber()) {
            return jsonReader.readLocalTime();
        }
        if (this.yyyyMMddhhmmss19 || this.formatISO8601) {
            return jsonReader.readLocalDateTime().toLocalTime();
        }
        String str = jsonReader.readString();
        if (str.isEmpty()) {
            return null;
        }
        if (this.formatMillis || this.formatUnixTime) {
            long millis = Long.parseLong(str);
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, context.getZoneId()).toLocalTime();
        }
        DateTimeFormatter formatter = this.getDateFormatter(context.getLocale());
        if (this.formatHasDay) {
            return LocalDateTime.parse(str, formatter).toLocalTime();
        }
        return LocalTime.parse(str, formatter);
    }
}

