/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.reader;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lonelibs.com.alibaba.fastjson2.JSON;
import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONFactory;
import lonelibs.com.alibaba.fastjson2.JSONPath;
import lonelibs.com.alibaba.fastjson2.JSONReader;
import lonelibs.com.alibaba.fastjson2.codec.FieldInfo;
import lonelibs.com.alibaba.fastjson2.internal.asm.ASMUtils;
import lonelibs.com.alibaba.fastjson2.reader.FieldReader;
import lonelibs.com.alibaba.fastjson2.reader.ObjectReader;
import lonelibs.com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import lonelibs.com.alibaba.fastjson2.reader.ObjectReaderProvider;
import lonelibs.com.alibaba.fastjson2.reader.ObjectReaders;
import lonelibs.com.alibaba.fastjson2.schema.JSONSchema;
import lonelibs.com.alibaba.fastjson2.util.BeanUtils;
import lonelibs.com.alibaba.fastjson2.util.Fnv;

final class ObjectReaderException<T>
extends ObjectReaderAdapter<T> {
    static final long HASH_TYPE = Fnv.hashCode64("@type");
    static final long HASH_MESSAGE = Fnv.hashCode64("message");
    static final long HASH_DETAIL_MESSAGE = Fnv.hashCode64("detailMessage");
    static final long HASH_LOCALIZED_MESSAGE = Fnv.hashCode64("localizedMessage");
    static final long HASH_CAUSE = Fnv.hashCode64("cause");
    static final long HASH_STACKTRACE = Fnv.hashCode64("stackTrace");
    static final long HASH_SUPPRESSED_EXCEPTIONS = Fnv.hashCode64("suppressedExceptions");
    private final FieldReader fieldReaderStackTrace;
    final List<Constructor> constructors;
    final Constructor constructorDefault;
    final Constructor constructorMessage;
    final Constructor constructorMessageCause;
    final Constructor constructorCause;
    final List<String[]> constructorParameters;

    ObjectReaderException(Class<T> objectClass) {
        this(objectClass, Arrays.asList(BeanUtils.getConstructor(objectClass)), ObjectReaders.fieldReader("stackTrace", StackTraceElement[].class, Throwable::setStackTrace));
    }

    ObjectReaderException(Class<T> objectClass, List<Constructor> constructors, FieldReader ... fieldReaders) {
        super((Class)objectClass, (String)null, objectClass.getName(), 0L, (JSONSchema)null, null, (Function)null, fieldReaders);
        int paramCount;
        this.constructors = constructors;
        Constructor constructorDefault = null;
        Constructor constructorMessage = null;
        Constructor constructorMessageCause = null;
        Constructor constructorCause = null;
        for (Constructor constructor : constructors) {
            if (constructor == null || constructorMessageCause != null) continue;
            paramCount = constructor.getParameterCount();
            if (paramCount == 0) {
                constructorDefault = constructor;
                continue;
            }
            Class<?>[] paramTypes = constructor.getParameterTypes();
            Class<?> paramType0 = paramTypes[0];
            if (paramCount == 1) {
                if (paramType0 == String.class) {
                    constructorMessage = constructor;
                } else if (Throwable.class.isAssignableFrom(paramType0)) {
                    constructorCause = constructor;
                }
            }
            if (paramCount != 2 || paramType0 != String.class || !Throwable.class.isAssignableFrom(paramTypes[1])) continue;
            constructorMessageCause = constructor;
        }
        this.constructorDefault = constructorDefault;
        this.constructorMessage = constructorMessage;
        this.constructorMessageCause = constructorMessageCause;
        this.constructorCause = constructorCause;
        constructors.sort((left, right) -> {
            int x = left.getParameterCount();
            int y = right.getParameterCount();
            return Integer.compare(y, x);
        });
        this.constructorParameters = new ArrayList<String[]>(constructors.size());
        for (Constructor constructor : constructors) {
            paramCount = constructor.getParameterCount();
            String[] parameterNames = null;
            if (paramCount > 0) {
                parameterNames = ASMUtils.lookupParameterNames(constructor);
                Parameter[] parameters = constructor.getParameters();
                FieldInfo fieldInfo = new FieldInfo();
                for (int i = 0; i < parameters.length && i < parameterNames.length; ++i) {
                    fieldInfo.init();
                    Parameter parameter = parameters[i];
                    ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
                    provider.getFieldInfo(fieldInfo, objectClass, constructor, i, parameter);
                    if (fieldInfo.fieldName == null) continue;
                    parameterNames[i] = fieldInfo.fieldName;
                }
            }
            this.constructorParameters.add(parameterNames);
        }
        FieldReader fieldReaderStackTrace = null;
        for (FieldReader fieldReader : fieldReaders) {
            if (!"stackTrace".equals(fieldReader.fieldName) || fieldReader.fieldClass != StackTraceElement[].class) continue;
            fieldReaderStackTrace = fieldReader;
        }
        this.fieldReaderStackTrace = fieldReaderStackTrace;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        String[] paramNames;
        boolean objectStart = jsonReader.nextIfObjectStart();
        if (!objectStart && jsonReader.nextIfNullOrEmptyString()) {
            return null;
        }
        String message = null;
        String localizedMessage = null;
        Throwable cause = null;
        Object[] stackTrace = null;
        List suppressedExceptions = null;
        String stackTraceReference = null;
        String suppressedExceptionsReference = null;
        String causeReference = null;
        HashMap<void, void> fieldValues = null;
        HashMap<void, String> references = null;
        int i = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            if (i == 0 && hash == HASH_TYPE && jsonReader.isSupportAutoType(features)) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader reader = this.autoType(context, typeHash);
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass, features)) == null) {
                    throw new JSONException(jsonReader.info("No suitable ObjectReader found for" + typeName));
                }
                if (reader != this) {
                    return reader.readObject(jsonReader);
                }
            } else if (hash == HASH_MESSAGE || hash == HASH_DETAIL_MESSAGE) {
                message = jsonReader.readString();
            } else if (hash == HASH_LOCALIZED_MESSAGE) {
                localizedMessage = jsonReader.readString();
            } else if (hash == HASH_CAUSE) {
                if (jsonReader.isReference()) {
                    causeReference = jsonReader.readReference();
                } else {
                    cause = jsonReader.read(Throwable.class);
                }
            } else if (hash == HASH_STACKTRACE) {
                if (jsonReader.isReference()) {
                    stackTraceReference = jsonReader.readReference();
                } else {
                    stackTrace = jsonReader.read(StackTraceElement[].class);
                }
            } else if (hash == HASH_SUPPRESSED_EXCEPTIONS) {
                if (jsonReader.isReference()) {
                    suppressedExceptionsReference = jsonReader.readReference();
                } else {
                    suppressedExceptions = jsonReader.getType() == -110 ? (List)jsonReader.readAny() : jsonReader.readArray((Type)((Object)Throwable.class));
                }
            } else {
                void var21_29;
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldValues == null) {
                    fieldValues = new HashMap<void, void>();
                }
                if (fieldReader != null) {
                    String string = fieldReader.fieldName;
                } else {
                    String string = jsonReader.getFieldName();
                }
                if (jsonReader.isReference()) {
                    String reference = jsonReader.readReference();
                    if (references == null) {
                        references = new HashMap<void, String>();
                    }
                    references.put(var21_29, reference);
                } else {
                    void var22_42;
                    if (fieldReader != null) {
                        Object object = fieldReader.readFieldValue(jsonReader);
                    } else {
                        Object object = jsonReader.readAny();
                    }
                    fieldValues.put(var21_29, var22_42);
                }
            }
            ++i;
        }
        Throwable object = this.createObject(message, cause);
        if (object == null) {
            for (int i2 = 0; i2 < this.constructors.size(); ++i2) {
                void var22_45;
                paramNames = this.constructorParameters.get(i2);
                if (paramNames == null || paramNames.length == 0) continue;
                boolean matchAll = true;
                block23: for (String paramName : paramNames) {
                    if (paramName == null) {
                        matchAll = false;
                        break;
                    }
                    switch (paramName) {
                        case "message": 
                        case "cause": {
                            continue block23;
                        }
                        case "errorIndex": {
                            if (this.objectClass == DateTimeParseException.class || fieldValues.containsKey(paramName)) continue block23;
                            matchAll = false;
                            continue block23;
                        }
                        default: {
                            if (fieldValues.containsKey(paramName)) continue block23;
                            matchAll = false;
                        }
                    }
                }
                if (!matchAll) continue;
                Object[] objectArray = new Object[paramNames.length];
                boolean bl = false;
                while (var22_45 < paramNames.length) {
                    Object fieldValue;
                    String paramName;
                    switch (paramName = paramNames[var22_45]) {
                        case "message": {
                            fieldValue = message;
                            break;
                        }
                        case "cause": {
                            fieldValue = cause;
                            break;
                        }
                        case "errorIndex": {
                            fieldValue = fieldValues.get(paramName);
                            if (fieldValue != null || this.objectClass != DateTimeParseException.class) break;
                            fieldValue = 0;
                            break;
                        }
                        default: {
                            fieldValue = fieldValues.get(paramName);
                        }
                    }
                    objectArray[var22_45] = fieldValue;
                    ++var22_45;
                }
                Constructor constructor = this.constructors.get(i2);
                try {
                    object = (Throwable)constructor.newInstance(objectArray);
                    break;
                }
                catch (Throwable e) {
                    throw new JSONException("create error, objectClass " + constructor + ", " + e.getMessage(), e);
                }
            }
        }
        if (object == null) {
            throw new JSONException(jsonReader.info(jsonReader.info("not support : " + this.objectClass.getName())));
        }
        if (stackTrace != null) {
            void var21_37;
            int nullCount = 0;
            paramNames = stackTrace;
            int matchAll = paramNames.length;
            boolean bl = false;
            while (var21_37 < matchAll) {
                String string = paramNames[var21_37];
                if (string == null) {
                    ++nullCount;
                }
                ++var21_37;
            }
            if (stackTrace.length == 0 || nullCount != stackTrace.length) {
                object.setStackTrace((StackTraceElement[])stackTrace);
            }
        }
        if (stackTraceReference != null) {
            jsonReader.addResolveTask(this.fieldReaderStackTrace, (Object)object, JSONPath.of(stackTraceReference));
        }
        if (fieldValues != null) {
            for (Map.Entry entry : fieldValues.entrySet()) {
                FieldReader fieldReader = this.getFieldReader((String)entry.getKey());
                if (fieldReader == null) continue;
                fieldReader.accept(object, entry.getValue());
            }
        }
        if (references != null) {
            for (Map.Entry entry : references.entrySet()) {
                FieldReader fieldReader = this.getFieldReader((String)entry.getKey());
                if (fieldReader == null) continue;
                fieldReader.addResolveTask(jsonReader, object, (String)entry.getValue());
            }
        }
        return (T)object;
    }

    @Override
    public T createInstance(Map map, long features) {
        if (map == null) {
            return null;
        }
        return this.readObject(JSONReader.of(JSON.toJSONString(map)), features);
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.getType() == -110) {
            JSONReader.Context context = jsonReader.getContext();
            if (jsonReader.isSupportAutoType(features) || context.getContextAutoTypeBeforeHandler() != null) {
                String typeName;
                jsonReader.next();
                long typeHash = jsonReader.readTypeHashCode();
                ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException("auoType not support : " + typeName + ", offset " + jsonReader.getOffset());
                }
                return autoTypeObjectReader.readJSONBObject(jsonReader, fieldType, fieldName, 0L);
            }
        }
        return this.readObject(jsonReader, fieldType, fieldName, features);
    }

    private Throwable createObject(String message, Throwable cause) {
        try {
            if (this.constructorMessageCause != null && cause != null && message != null) {
                return (Throwable)this.constructorMessageCause.newInstance(message, cause);
            }
            if (this.constructorMessage != null && message != null) {
                return (Throwable)this.constructorMessage.newInstance(message);
            }
            if (this.constructorCause != null && cause != null) {
                return (Throwable)this.constructorCause.newInstance(cause);
            }
            if (this.constructorMessageCause != null && (cause != null || message != null)) {
                return (Throwable)this.constructorMessageCause.newInstance(message, cause);
            }
            if (this.constructorDefault != null) {
                return (Throwable)this.constructorDefault.newInstance(new Object[0]);
            }
            if (this.constructorMessageCause != null) {
                return (Throwable)this.constructorMessageCause.newInstance(message, cause);
            }
            if (this.constructorMessage != null) {
                return (Throwable)this.constructorMessage.newInstance(message);
            }
            if (this.constructorCause != null) {
                return (Throwable)this.constructorCause.newInstance(cause);
            }
        }
        catch (Throwable e) {
            throw new JSONException("create Exception error, class " + this.objectClass.getName() + ", " + e.getMessage(), e);
        }
        return null;
    }
}

