/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.reader;

import java.lang.reflect.Field;
import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONReader;
import lonelibs.com.alibaba.fastjson2.reader.FieldReaderObjectField;
import lonelibs.com.alibaba.fastjson2.schema.JSONSchema;
import lonelibs.com.alibaba.fastjson2.util.TypeUtils;

final class FieldReaderInt64Field<T>
extends FieldReaderObjectField<T> {
    FieldReaderInt64Field(String fieldName, Class fieldType, int ordinal, long features, String format, Long defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, features, format, defaultValue, schema, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Long fieldValue = jsonReader.readInt64();
        if (this.schema != null) {
            this.schema.assertValidate(fieldValue);
        }
        try {
            this.field.set(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readInt64();
    }

    @Override
    public void accept(T object, float value) {
        this.accept(object, (Object)((long)value));
    }

    @Override
    public void accept(T object, double value) {
        this.accept(object, (Object)((long)value));
    }

    @Override
    public void accept(T object, Object value) {
        Long longValue = TypeUtils.toLong(value);
        if (this.schema != null) {
            this.schema.assertValidate(longValue);
        }
        try {
            this.field.set(object, longValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }
}

