/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.reader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONFactory;
import lonelibs.com.alibaba.fastjson2.JSONReader;
import lonelibs.com.alibaba.fastjson2.reader.FieldReaderObject;
import lonelibs.com.alibaba.fastjson2.schema.JSONSchema;

class FieldReaderCollectionMethodReadOnly<T>
extends FieldReaderObject<T> {
    FieldReaderCollectionMethodReadOnly(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, JSONSchema schema, Method setter, Field field) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, null, null, schema, setter, field, null);
        Type[] actualTypeArguments;
        Type itemType = null;
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments()).length > 0) {
            itemType = actualTypeArguments[0];
        }
        this.itemType = itemType;
    }

    @Override
    public void accept(T object, Object value) {
        Collection collection;
        if (value == null) {
            return;
        }
        try {
            collection = (Collection)this.method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
        if (collection == Collections.EMPTY_LIST || collection == Collections.EMPTY_SET || collection == null || collection.equals(value)) {
            if (this.schema != null) {
                this.schema.assertValidate(collection);
            }
            return;
        }
        String name = collection.getClass().getName();
        if ("java.util.Collections$UnmodifiableRandomAccessList".equals(name) || "java.util.Arrays$ArrayList".equals(name) || "java.util.Collections$SingletonList".equals(name) || name.startsWith("java.util.ImmutableCollections$")) {
            return;
        }
        if (value == collection) {
            return;
        }
        Collection values = (Collection)value;
        for (Object item : values) {
            if (item == null) {
                collection.add(null);
                continue;
            }
            if (item instanceof Map && this.itemType instanceof Class && !((Class)this.itemType).isAssignableFrom(item.getClass())) {
                if (this.itemReader == null) {
                    this.itemReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(this.itemType);
                }
                item = this.itemReader.createInstance((Map)item, 0L);
            }
            collection.add(item);
        }
        if (this.schema != null) {
            this.schema.assertValidate(collection);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (this.initReader == null) {
            this.initReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        Object value = jsonReader.jsonb ? this.initReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, 0L) : this.initReader.readObject(jsonReader, this.fieldType, this.fieldName, 0L);
        this.accept(object, value);
    }
}

