/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.reader;

import java.lang.reflect.Field;
import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONReader;
import lonelibs.com.alibaba.fastjson2.reader.FieldReaderObjectField;
import lonelibs.com.alibaba.fastjson2.schema.JSONSchema;
import lonelibs.com.alibaba.fastjson2.util.TypeUtils;

final class FieldReaderBoolField<T>
extends FieldReaderObjectField<T> {
    FieldReaderBoolField(String fieldName, Class fieldType, int ordinal, long features, String format, Boolean defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, features, format, defaultValue, schema, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Boolean fieldValue = jsonReader.readBool();
        try {
            this.field.set(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void accept(T object, boolean value) {
        this.accept(object, (Object)value);
    }

    @Override
    public void accept(T object, int value) {
        this.accept(object, TypeUtils.toBoolean(value));
    }

    @Override
    public void accept(T object, Object value) {
        Boolean booleanValue = TypeUtils.toBoolean(value);
        if (this.schema != null) {
            this.schema.assertValidate(booleanValue);
        }
        try {
            this.field.set(object, booleanValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readBool();
    }
}

