/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2.reader;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONReader;
import lonelibs.com.alibaba.fastjson2.reader.FieldReader;
import lonelibs.com.alibaba.fastjson2.schema.JSONSchema;

final class FieldReaderAtomicLongReadOnly<T>
extends FieldReader<T> {
    FieldReaderAtomicLongReadOnly(String fieldName, Class fieldType, int ordinal, JSONSchema schema, Method method) {
        super(fieldName, fieldType, fieldType, ordinal, 0L, null, null, null, schema, method, null);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void accept(T object, Object value) {
        if (value == null) {
            return;
        }
        try {
            AtomicLong atomic = (AtomicLong)this.method.invoke(object, new Object[0]);
            long longValue = ((Number)value).longValue();
            atomic.set(longValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Long value = jsonReader.readInt64();
        this.accept(object, value);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        long longValue = jsonReader.readInt64Value();
        if (jsonReader.wasNull()) {
            return null;
        }
        return new AtomicLong(longValue);
    }
}

