/*
 * Decompiled with CFR 0.152.
 */
package lonelibs.com.alibaba.fastjson2;

import lonelibs.com.alibaba.fastjson2.JSONException;
import lonelibs.com.alibaba.fastjson2.JSONReader;

public class JSONValidator {
    private final JSONReader jsonReader;
    private Boolean validateResult;
    private Type type;

    protected JSONValidator(JSONReader jsonReader) {
        this.jsonReader = jsonReader;
    }

    public static JSONValidator fromUtf8(byte[] jsonBytes) {
        return new JSONValidator(JSONReader.of(jsonBytes));
    }

    public static JSONValidator from(String jsonStr) {
        return new JSONValidator(JSONReader.of(jsonStr));
    }

    public static JSONValidator from(JSONReader jsonReader) {
        return new JSONValidator(jsonReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        char firstChar;
        if (this.validateResult != null) {
            return this.validateResult;
        }
        try {
            firstChar = this.jsonReader.current();
            this.jsonReader.skipValue();
        }
        catch (JSONException error) {
            this.validateResult = false;
            boolean bl = this.validateResult;
            return bl;
        }
        finally {
            this.jsonReader.close();
        }
        this.type = firstChar == '{' ? Type.Object : (firstChar == '[' ? Type.Array : Type.Value);
        this.validateResult = this.jsonReader.isEnd();
        return this.validateResult;
    }

    public Type getType() {
        if (this.type == null) {
            this.validate();
        }
        return this.type;
    }

    public static enum Type {
        Object,
        Array,
        Value;

    }
}

