/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.fastparticle;

import fr.mrmicky.fastparticle.ParticleType;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.material.MaterialData;

interface ParticleSender {
    public void spawnParticle(Object var1, ParticleType var2, double var3, double var5, double var7, int var9, double var10, double var12, double var14, double var16, Object var18);

    public Object getParticle(ParticleType var1);

    public boolean isValidData(Object var1, Object var2);

    default public double color(double color) {
        return color / 255.0;
    }

    public static class ParticleSender1_13
    extends ParticleSenderImpl {
        @Override
        public void spawnParticle(Object receiver, ParticleType particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, Object data) {
            Particle bukkitParticle = Particle.valueOf((String)particle.toString());
            if (bukkitParticle.getDataType() == Particle.DustOptions.class) {
                if (data instanceof Color) {
                    data = new Particle.DustOptions((Color)data, 1.0f);
                } else if (data == null) {
                    data = new Particle.DustOptions(Color.RED, 1.0f);
                }
            } else if (bukkitParticle.getDataType() == BlockData.class && data instanceof MaterialData) {
                data = Bukkit.createBlockData((Material)((MaterialData)data).getItemType());
            }
            super.spawnParticle(receiver, particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data);
        }

        @Override
        public boolean isValidDataBukkit(Particle particle, Object data) {
            if (particle.getDataType() == Particle.DustOptions.class && data instanceof Color) {
                return true;
            }
            if (particle.getDataType() == BlockData.class && data instanceof MaterialData) {
                return true;
            }
            return super.isValidDataBukkit(particle, data);
        }
    }

    public static class ParticleSenderImpl
    implements ParticleSender {
        @Override
        public void spawnParticle(Object receiver, ParticleType particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, Object data) {
            Particle bukkitParticle = Particle.valueOf((String)particle.toString());
            if (data instanceof Color) {
                if (particle.getDataType() == Color.class) {
                    Color color = (Color)data;
                    count = 0;
                    offsetX = this.color(color.getRed());
                    offsetY = this.color(color.getGreen());
                    offsetZ = this.color(color.getBlue());
                    extra = 1.0;
                }
                data = null;
            }
            if (receiver instanceof World) {
                ((World)receiver).spawnParticle(bukkitParticle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data);
            } else if (receiver instanceof Player) {
                ((Player)receiver).spawnParticle(bukkitParticle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data);
            }
        }

        public Particle getParticle(ParticleType particle) {
            try {
                return Particle.valueOf((String)particle.toString());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Override
        public boolean isValidData(Object particle, Object data) {
            return this.isValidDataBukkit((Particle)particle, data);
        }

        public boolean isValidDataBukkit(Particle particle, Object data) {
            return particle.getDataType() == Void.class || particle.getDataType().isInstance(data);
        }
    }
}

