/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.LoneLibs.data;

import dev.lone.LoneLibs.Main;
import dev.lone.LoneLibs.Scheduler;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lonelibs.org.jetbrains.annotations.NotNull;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class WeakConcurrentCacheHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private final Map<K, Long> times = new ConcurrentHashMap<K, Long>();
    private long expirationTicks = 6000L;
    private BukkitTask bukkitTask;

    public WeakConcurrentCacheHashMap() {
        this.init();
    }

    public WeakConcurrentCacheHashMap(long expirationTicks) {
        this.expirationTicks = expirationTicks;
        this.init();
    }

    public void init() {
        Scheduler scheduler = new Scheduler((Plugin)Main.inst);
        this.bukkitTask = scheduler.asyncLoop(task -> this.cleanup(), this.expirationTicks, this.expirationTicks);
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        if (this.bukkitTask == null || this.bukkitTask.isCancelled()) {
            this.init();
        }
        this.times.put(key, System.currentTimeMillis());
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), m.get(entry.getKey()));
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!this.containsKey(key)) {
            return this.put(key, value);
        }
        return this.get(key);
    }

    @Override
    public V remove(@NotNull Object key) {
        Object remove = super.remove(key);
        if (remove != null && this.size() == 0) {
            this.cancelTask();
        }
        return remove;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean remove = super.remove(key, value);
        if (remove && this.size() == 0) {
            this.cancelTask();
        }
        return remove;
    }

    public void deleteCompletely() {
        this.clear();
        this.times.clear();
        this.cancelTask();
    }

    private void cleanup() {
        long currentMs = System.currentTimeMillis();
        Iterator<Map.Entry<K, Long>> iterator = this.times.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, Long> entry = iterator.next();
            if (currentMs < this.times.get(entry.getKey()) + this.expirationTicks) continue;
            iterator.remove();
            this.times.remove(entry.getKey());
        }
        if (this.size() == 0) {
            this.cancelTask();
        }
    }

    private void cancelTask() {
        if (this.bukkitTask == null) {
            return;
        }
        this.bukkitTask.cancel();
        this.bukkitTask = null;
    }
}

