/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.LoneLibs.data;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class HashMapPrimitive<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6767664750549425943L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    transient Node<K, V>[] table;
    transient Set<Entry<K, V>> entrySet;
    transient int size;
    transient int modCount;
    int threshold;
    final float loadFactor;

    static final int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    static int compareComparables(Object k, Object x) {
        return x == null ? 0 : ((Comparable)k).compareTo(x);
    }

    static final int tableSizeFor(int cap) {
        int n = -1 >>> Integer.numberOfLeadingZeros(cap - 1);
        return n < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public HashMapPrimitive(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = HashMapPrimitive.tableSizeFor(initialCapacity);
    }

    public HashMapPrimitive(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMapPrimitive() {
        this.loadFactor = 0.75f;
    }

    public HashMapPrimitive(Map<? extends K, ? extends V> m) {
        this.loadFactor = 0.75f;
        this.putMapEntries(m, false);
    }

    final void putMapEntries(Map<? extends K, ? extends V> m, boolean evict) {
        int s = m.size();
        if (s > 0) {
            if (this.table == null) {
                int t;
                float ft = (float)s / this.loadFactor + 1.0f;
                int n = t = ft < 1.0737418E9f ? (int)ft : 0x40000000;
                if (t > this.threshold) {
                    this.threshold = HashMapPrimitive.tableSizeFor(t);
                }
            } else {
                while (s > this.threshold && this.table.length < 0x40000000) {
                    this.resize();
                }
            }
            for (Map.Entry<K, V> e : m.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                this.putVal(HashMapPrimitive.hash(key), key, value, false, evict);
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        Node<K, V> e = this.getNode(key);
        return e == null ? null : (V)e.value;
    }

    final Node<K, V> getNode(Object key) {
        int hash;
        Node<K, V> first;
        int n;
        Node<K, V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (first = tab[n - 1 & (hash = HashMapPrimitive.hash(key))]) != null) {
            Object k;
            if (first.hash == hash && ((k = first.key) == key || key != null && key.equals(k))) {
                return first;
            }
            Node e = first.next;
            if (e != null) {
                if (first instanceof TreeNode) {
                    return ((TreeNode)first).getTreeNode(hash, key);
                }
                do {
                    if (e.hash != hash || (k = e.key) != key && (key == null || !key.equals(k))) continue;
                    return e;
                } while ((e = e.next) != null);
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getNode(key) != null;
    }

    @Override
    public V put(K key, V value) {
        return this.putVal(HashMapPrimitive.hash(key), key, value, false, true);
    }

    final V putVal(int hash, K key, V value, boolean onlyIfAbsent, boolean evict) {
        int i;
        Node<K, V> p2;
        int n;
        Node<K, V>[] tab = this.table;
        if (this.table == null || (n = tab.length) == 0) {
            tab = this.resize();
            n = tab.length;
        }
        if ((p2 = tab[i = n - 1 & hash]) == null) {
            tab[i] = this.newNode(hash, key, value, null);
        } else {
            Node<K, V> e;
            Object k;
            if (p2.hash == hash && ((k = p2.key) == key || key != null && key.equals(k))) {
                e = p2;
            } else if (p2 instanceof TreeNode) {
                e = ((TreeNode)p2).putTreeVal(this, tab, hash, key, value);
            } else {
                int binCount = 0;
                while (true) {
                    if ((e = p2.next) == null) {
                        p2.next = this.newNode(hash, key, value, null);
                        if (binCount < 7) break;
                        this.treeifyBin(tab, hash);
                        break;
                    }
                    if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) break;
                    p2 = e;
                    ++binCount;
                }
            }
            if (e != null) {
                Object oldValue = e.value;
                if (!onlyIfAbsent || oldValue == null) {
                    e.value = value;
                }
                this.afterNodeAccess(e);
                return oldValue;
            }
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.resize();
        }
        this.afterNodeInsertion(evict);
        return null;
    }

    final Node<K, V>[] resize() {
        int newCap;
        Node<K, V>[] oldTab = this.table;
        int oldCap = oldTab == null ? 0 : oldTab.length;
        int oldThr = this.threshold;
        int newThr = 0;
        if (oldCap > 0) {
            if (oldCap >= 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return oldTab;
            }
            newCap = oldCap << 1;
            if (newCap < 0x40000000 && oldCap >= 16) {
                newThr = oldThr << 1;
            }
        } else if (oldThr > 0) {
            newCap = oldThr;
        } else {
            newCap = 16;
            newThr = 12;
        }
        if (newThr == 0) {
            float ft = (float)newCap * this.loadFactor;
            newThr = newCap < 0x40000000 && ft < 1.0737418E9f ? (int)ft : Integer.MAX_VALUE;
        }
        this.threshold = newThr;
        Node[] newTab = new Node[newCap];
        this.table = newTab;
        if (oldTab != null) {
            for (int j = 0; j < oldCap; ++j) {
                Node next;
                Node<K, V> e = oldTab[j];
                if (e == null) continue;
                oldTab[j] = null;
                if (e.next == null) {
                    newTab[e.hash & newCap - 1] = e;
                    continue;
                }
                if (e instanceof TreeNode) {
                    ((TreeNode)e).split(this, newTab, j, oldCap);
                    continue;
                }
                Node<K, V> loHead = null;
                Node<K, V> loTail = null;
                Node<K, V> hiHead = null;
                Node<K, V> hiTail = null;
                do {
                    next = e.next;
                    if ((e.hash & oldCap) == 0) {
                        if (loTail == null) {
                            loHead = e;
                        } else {
                            loTail.next = e;
                        }
                        loTail = e;
                        continue;
                    }
                    if (hiTail == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                } while ((e = next) != null);
                if (loTail != null) {
                    loTail.next = null;
                    newTab[j] = loHead;
                }
                if (hiTail == null) continue;
                hiTail.next = null;
                newTab[j + oldCap] = hiHead;
            }
        }
        return newTab;
    }

    final void treeifyBin(Node<K, V>[] tab, int hash) {
        int n;
        if (tab == null || (n = tab.length) < 64) {
            this.resize();
        } else {
            int index = n - 1 & hash;
            Node<K, V> e = tab[index];
            if (e != null) {
                TreeNode<K, V> hd = null;
                TreeNode<K, V> tl = null;
                do {
                    TreeNode<K, V> p2 = this.replacementTreeNode(e, null);
                    if (tl == null) {
                        hd = p2;
                    } else {
                        p2.prev = tl;
                        tl.next = p2;
                    }
                    tl = p2;
                } while ((e = e.next) != null);
                tab[index] = hd;
                if (tab[index] != null) {
                    hd.treeify(tab);
                }
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putMapEntries(m, true);
    }

    @Override
    public V remove(Object key) {
        Node<K, V> e = this.removeNode(HashMapPrimitive.hash(key), key, null, false, true);
        return e == null ? null : (V)e.value;
    }

    final Node<K, V> removeNode(int hash, Object key, Object value, boolean matchValue, boolean movable) {
        int index;
        Node<K, V> p2;
        int n;
        Node<K, V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (p2 = tab[index = n - 1 & hash]) != null) {
            Object v;
            Object k;
            Node<K, V> node = null;
            if (p2.hash == hash && ((k = p2.key) == key || key != null && key.equals(k))) {
                node = p2;
            } else {
                Node e = p2.next;
                if (e != null) {
                    if (p2 instanceof TreeNode) {
                        node = ((TreeNode)p2).getTreeNode(hash, key);
                    } else {
                        do {
                            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                                node = e;
                                break;
                            }
                            p2 = e;
                        } while ((e = e.next) != null);
                    }
                }
            }
            if (node != null && (!matchValue || (v = node.value) == value || value != null && value.equals(v))) {
                if (node instanceof TreeNode) {
                    ((TreeNode)node).removeTreeNode(this, tab, movable);
                } else if (node == p2) {
                    tab[index] = node.next;
                } else {
                    p2.next = node.next;
                }
                ++this.modCount;
                --this.size;
                this.afterNodeRemoval(node);
                return node;
            }
        }
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Node<K, V>[] tab = this.table;
        if (this.table != null && this.size > 0) {
            this.size = 0;
            for (int i = 0; i < tab.length; ++i) {
                tab[i] = null;
            }
        }
    }

    @Override
    public boolean containsValue(Object value) {
        Node<K, V>[] tab = this.table;
        if (this.table != null && this.size > 0) {
            for (Node<K, V> e : tab) {
                while (e != null) {
                    Object v = e.value;
                    if (v == value || value != null && value.equals(v)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        throw new RuntimeException("Not implemented!");
    }

    final <T> T[] prepareArray(T[] a) {
        int size = this.size;
        if (a.length < size) {
            return (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    <T> T[] keysToArray(T[] a) {
        T[] r = a;
        int idx = 0;
        if (this.size > 0) {
            Node<K, V>[] tab = this.table;
            if (this.table != null) {
                for (Node<K, V> e : tab) {
                    while (e != null) {
                        r[idx++] = e.key;
                        e = e.next;
                    }
                }
            }
        }
        return a;
    }

    <T> T[] valuesToArray(T[] a) {
        T[] r = a;
        int idx = 0;
        if (this.size > 0) {
            Node<K, V>[] tab = this.table;
            if (this.table != null) {
                for (Node<K, V> e : tab) {
                    while (e != null) {
                        r[idx++] = e.value;
                        e = e.next;
                    }
                }
            }
        }
        return a;
    }

    @Override
    public Collection<V> values() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        Node<K, V> e = this.getNode(key);
        return e == null ? defaultValue : e.value;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putVal(HashMapPrimitive.hash(key), key, value, true, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.removeNode(HashMapPrimitive.hash(key), key, value, true, true) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object v;
        Node<K, V> e = this.getNode(key);
        if (e != null && ((v = e.value) == oldValue || v != null && v.equals(oldValue))) {
            e.value = newValue;
            this.afterNodeAccess(e);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        Node<K, V> e = this.getNode(key);
        if (e != null) {
            Object oldValue = e.value;
            e.value = value;
            this.afterNodeAccess(e);
            return oldValue;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        int i;
        Node<K, V> first;
        int n;
        Node<K, V>[] tab;
        Node old;
        TreeNode t;
        int binCount;
        int hash;
        block17: {
            block16: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                hash = HashMapPrimitive.hash(key);
                binCount = 0;
                t = null;
                old = null;
                if (this.size > this.threshold) break block16;
                tab = this.table;
                if (this.table != null && (n = tab.length) != 0) break block17;
            }
            tab = this.resize();
            n = tab.length;
        }
        if ((first = tab[i = n - 1 & hash]) != null) {
            Object oldValue;
            if (first instanceof TreeNode) {
                t = (TreeNode)first;
                old = t.getTreeNode(hash, key);
            } else {
                Node<K, V> e = first;
                do {
                    Object k;
                    if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                        old = e;
                        break;
                    }
                    ++binCount;
                } while ((e = e.next) != null);
            }
            if (old != null && (oldValue = old.value) != null) {
                this.afterNodeAccess(old);
                return oldValue;
            }
        }
        int mc = this.modCount;
        V v = mappingFunction.apply(key);
        if (mc != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (v == null) {
            return null;
        }
        if (old != null) {
            old.value = v;
            this.afterNodeAccess(old);
            return v;
        }
        if (t != null) {
            t.putTreeVal(this, tab, hash, key, v);
        } else {
            tab[i] = this.newNode(hash, key, v, first);
            if (binCount >= 7) {
                this.treeifyBin(tab, hash);
            }
        }
        this.modCount = mc + 1;
        ++this.size;
        this.afterNodeInsertion(true);
        return v;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        Node<K, V> e = this.getNode(key);
        if (e != null && (oldValue = e.value) != null) {
            int mc = this.modCount;
            V v = remappingFunction.apply(key, oldValue);
            if (mc != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (v != null) {
                e.value = v;
                this.afterNodeAccess(e);
                return v;
            }
            int hash = HashMapPrimitive.hash(key);
            this.removeNode(hash, key, null, false, true);
        }
        return null;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        int i;
        Node<K, V> first;
        int n;
        Node<K, V>[] tab;
        Node old;
        TreeNode t;
        int binCount;
        int hash;
        block19: {
            block18: {
                if (remappingFunction == null) {
                    throw new NullPointerException();
                }
                hash = HashMapPrimitive.hash(key);
                binCount = 0;
                t = null;
                old = null;
                if (this.size > this.threshold) break block18;
                tab = this.table;
                if (this.table != null && (n = tab.length) != 0) break block19;
            }
            tab = this.resize();
            n = tab.length;
        }
        if ((first = tab[i = n - 1 & hash]) != null) {
            if (first instanceof TreeNode) {
                t = (TreeNode)first;
                old = t.getTreeNode(hash, key);
            } else {
                Node<K, V> e = first;
                do {
                    Object k;
                    if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                        old = e;
                        break;
                    }
                    ++binCount;
                } while ((e = e.next) != null);
            }
        }
        Object oldValue = old == null ? null : (Object)old.value;
        int mc = this.modCount;
        V v = remappingFunction.apply(key, oldValue);
        if (mc != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (old != null) {
            if (v != null) {
                old.value = v;
                this.afterNodeAccess(old);
            } else {
                this.removeNode(hash, key, null, false, true);
            }
        } else if (v != null) {
            if (t != null) {
                t.putTreeVal(this, tab, hash, key, v);
            } else {
                tab[i] = this.newNode(hash, key, v, first);
                if (binCount >= 7) {
                    this.treeifyBin(tab, hash);
                }
            }
            this.modCount = mc + 1;
            ++this.size;
            this.afterNodeInsertion(true);
        }
        return v;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        int i;
        Node<K, V> first;
        int n;
        Node<K, V>[] tab;
        Node old;
        TreeNode t;
        int binCount;
        int hash;
        block20: {
            block19: {
                if (value == null || remappingFunction == null) {
                    throw new NullPointerException();
                }
                hash = HashMapPrimitive.hash(key);
                binCount = 0;
                t = null;
                old = null;
                if (this.size > this.threshold) break block19;
                tab = this.table;
                if (this.table != null && (n = tab.length) != 0) break block20;
            }
            tab = this.resize();
            n = tab.length;
        }
        if ((first = tab[i = n - 1 & hash]) != null) {
            if (first instanceof TreeNode) {
                t = (TreeNode)first;
                old = t.getTreeNode(hash, key);
            } else {
                Node<K, V> e = first;
                do {
                    Object k;
                    if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                        old = e;
                        break;
                    }
                    ++binCount;
                } while ((e = e.next) != null);
            }
        }
        if (old != null) {
            V v;
            if (old.value != null) {
                int mc = this.modCount;
                v = remappingFunction.apply(old.value, value);
                if (mc != this.modCount) {
                    throw new ConcurrentModificationException();
                }
            } else {
                v = value;
            }
            if (v != null) {
                old.value = v;
                this.afterNodeAccess(old);
            } else {
                this.removeNode(hash, key, null, false, true);
            }
            return v;
        }
        if (t != null) {
            t.putTreeVal(this, tab, hash, key, value);
        } else {
            tab[i] = this.newNode(hash, key, value, first);
            if (binCount >= 7) {
                this.treeifyBin(tab, hash);
            }
        }
        ++this.modCount;
        ++this.size;
        this.afterNodeInsertion(true);
        return value;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node<K, V>[] tab = this.table;
            if (this.table != null) {
                int mc = this.modCount;
                for (Node<K, V> e : tab) {
                    while (e != null) {
                        action.accept(e.key, e.value);
                        e = e.next;
                    }
                }
                if (this.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node<K, V>[] tab = this.table;
            if (this.table != null) {
                int mc = this.modCount;
                for (Node<K, V> e : tab) {
                    while (e != null) {
                        e.value = function.apply(e.key, e.value);
                        e = e.next;
                    }
                }
                if (this.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public Object clone() {
        HashMapPrimitive result;
        try {
            result = (HashMapPrimitive)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        result.reinitialize();
        result.putMapEntries(this, false);
        return result;
    }

    final float loadFactor() {
        return this.loadFactor;
    }

    final int capacity() {
        return this.table != null ? this.table.length : (this.threshold > 0 ? this.threshold : 16);
    }

    Node<K, V> newNode(int hash, K key, V value, Node<K, V> next) {
        return new Node<K, V>(hash, key, value, next);
    }

    Node<K, V> replacementNode(Node<K, V> p2, Node<K, V> next) {
        return new Node(p2.hash, p2.key, p2.value, next);
    }

    TreeNode<K, V> newTreeNode(int hash, K key, V value, Node<K, V> next) {
        return new TreeNode<K, V>(hash, key, value, next);
    }

    TreeNode<K, V> replacementTreeNode(Node<K, V> p2, Node<K, V> next) {
        return new TreeNode(p2.hash, p2.key, p2.value, next);
    }

    void reinitialize() {
        throw new RuntimeException("Not implemented!");
    }

    void afterNodeAccess(Node<K, V> p2) {
    }

    void afterNodeInsertion(boolean evict) {
    }

    void afterNodeRemoval(Node<K, V> p2) {
    }

    void internalWriteEntries(ObjectOutputStream s) throws IOException {
        if (this.size > 0) {
            Node<K, V>[] tab = this.table;
            if (this.table != null) {
                for (Node<K, V> e : tab) {
                    while (e != null) {
                        s.writeObject(e.key);
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
            }
        }
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Node<K, V> next;

        Node(int hash, K key, V value, Node<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.key, e.getKey()) && Objects.equals(this.value, e.getValue());
            }
            return false;
        }
    }

    static final class TreeNode<K, V>
    extends Entry<K, V> {
        TreeNode<K, V> parent;
        TreeNode<K, V> left;
        TreeNode<K, V> right;
        TreeNode<K, V> prev;
        boolean red;

        TreeNode(int hash, K key, V val, Node<K, V> next) {
            super(hash, key, val, next);
        }

        final TreeNode<K, V> root() {
            TreeNode<K, V> r = this;
            TreeNode<K, V> p2;
            while ((p2 = r.parent) != null) {
                r = p2;
            }
            return r;
        }

        static <K, V> void moveRootToFront(Node<K, V>[] tab, TreeNode<K, V> root) {
            int n;
            if (root != null && tab != null && (n = tab.length) > 0) {
                int index = n - 1 & root.hash;
                TreeNode first = (TreeNode)tab[index];
                if (root != first) {
                    tab[index] = root;
                    TreeNode<K, V> rp = root.prev;
                    Node rn = root.next;
                    if (rn != null) {
                        ((TreeNode)rn).prev = rp;
                    }
                    if (rp != null) {
                        rp.next = rn;
                    }
                    if (first != null) {
                        first.prev = root;
                    }
                    root.next = first;
                    root.prev = null;
                }
                assert (TreeNode.checkInvariants(root));
            }
        }

        final TreeNode<K, V> find(int h, Object k, Class<?> kc) {
            TreeNode<K, V> p2 = this;
            do {
                int dir;
                TreeNode<K, V> pl = p2.left;
                TreeNode<K, V> pr = p2.right;
                int ph = p2.hash;
                if (ph > h) {
                    p2 = pl;
                    continue;
                }
                if (ph < h) {
                    p2 = pr;
                    continue;
                }
                Object pk = p2.key;
                if (pk == k || k != null && k.equals(pk)) {
                    return p2;
                }
                if (pl == null) {
                    p2 = pr;
                    continue;
                }
                if (pr == null) {
                    p2 = pl;
                    continue;
                }
                if ((kc != null || (kc = k != null ? k.getClass() : null) != null) && (dir = HashMapPrimitive.compareComparables(k, pk)) != 0) {
                    p2 = dir < 0 ? pl : pr;
                    continue;
                }
                TreeNode<K, V> q = pr.find(h, k, kc);
                if (q != null) {
                    return q;
                }
                p2 = pl;
            } while (p2 != null);
            return null;
        }

        final TreeNode<K, V> getTreeNode(int h, Object k) {
            return (this.parent != null ? this.root() : this).find(h, k, null);
        }

        static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        final void treeify(Node<K, V>[] tab) {
            TreeNode<K, V> root = null;
            TreeNode<K, V> x = this;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (root == null) {
                    x.parent = null;
                    x.red = false;
                    root = x;
                } else {
                    TreeNode<K, V> xp;
                    int dir;
                    Object k = x.key;
                    int h = x.hash;
                    Class<?> kc = null;
                    TreeNode<K, V> p2 = root;
                    do {
                        Object pk = p2.key;
                        int ph = p2.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else if (kc == null && (kc = k.getClass()) == null || (dir = HashMapPrimitive.compareComparables(k, pk)) == 0) {
                            dir = TreeNode.tieBreakOrder(k, pk);
                        }
                        xp = p2;
                    } while ((p2 = dir <= 0 ? p2.left : p2.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    root = TreeNode.balanceInsertion(root, x);
                }
                x = next;
            }
            TreeNode.moveRootToFront(tab, root);
        }

        final Node<K, V> untreeify(HashMapPrimitive<K, V> map) {
            Node<K, V> hd = null;
            Node<K, V> tl = null;
            Node q = this;
            while (q != null) {
                Node<K, V> p2 = map.replacementNode(q, null);
                if (tl == null) {
                    hd = p2;
                } else {
                    tl.next = p2;
                }
                tl = p2;
                q = q.next;
            }
            return hd;
        }

        final TreeNode<K, V> putTreeVal(HashMapPrimitive<K, V> map, Node<K, V>[] tab, int h, K k, V v) {
            TreeNode<K, V> xp;
            int dir;
            TreeNode<K, V> root;
            Class<?> kc = null;
            boolean searched = false;
            TreeNode<K, V> p2 = root = this.parent != null ? this.root() : this;
            do {
                int ph;
                if ((ph = p2.hash) > h) {
                    dir = -1;
                } else if (ph < h) {
                    dir = 1;
                } else {
                    Object pk = p2.key;
                    if (pk == k || k != null && k.equals(pk)) {
                        return p2;
                    }
                    if (kc == null && (kc = k.getClass()) == null || (dir = HashMapPrimitive.compareComparables(k, pk)) == 0) {
                        if (!searched) {
                            TreeNode<K, V> q;
                            searched = true;
                            TreeNode<K, V> ch = p2.left;
                            if (ch != null && (q = ch.find(h, k, kc)) != null || (ch = p2.right) != null && (q = ch.find(h, k, kc)) != null) {
                                return q;
                            }
                        }
                        dir = TreeNode.tieBreakOrder(k, pk);
                    }
                }
                xp = p2;
            } while ((p2 = dir <= 0 ? p2.left : p2.right) != null);
            Node xpn = xp.next;
            TreeNode<K, V> x = map.newTreeNode(h, k, v, xpn);
            if (dir <= 0) {
                xp.left = x;
            } else {
                xp.right = x;
            }
            xp.next = x;
            x.prev = xp;
            x.parent = x.prev;
            if (xpn != null) {
                ((TreeNode)xpn).prev = x;
            }
            TreeNode.moveRootToFront(tab, TreeNode.balanceInsertion(root, x));
            return null;
        }

        final void removeTreeNode(HashMapPrimitive<K, V> map, Node<K, V>[] tab, boolean movable) {
            TreeNode<K, V> r;
            TreeNode<K, V> replacement;
            TreeNode<K, V> rl;
            TreeNode<K, V> first;
            int n;
            if (tab == null || (n = tab.length) == 0) {
                return;
            }
            int index = n - 1 & this.hash;
            TreeNode<K, V> root = first = (TreeNode<K, V>)tab[index];
            TreeNode succ = (TreeNode)this.next;
            TreeNode<K, V> pred = this.prev;
            if (pred == null) {
                first = succ;
                tab[index] = first;
            } else {
                pred.next = succ;
            }
            if (succ != null) {
                succ.prev = pred;
            }
            if (first == null) {
                return;
            }
            if (root.parent != null) {
                root = root.root();
            }
            if (root == null || movable && (root.right == null || (rl = root.left) == null || rl.left == null)) {
                tab[index] = first.untreeify(map);
                return;
            }
            TreeNode<K, V> p2 = this;
            TreeNode<K, V> pl = this.left;
            TreeNode<K, V> pr = this.right;
            if (pl != null && pr != null) {
                TreeNode<K, V> sl;
                TreeNode<K, V> s = pr;
                while ((sl = s.left) != null) {
                    s = sl;
                }
                boolean c = s.red;
                s.red = p2.red;
                p2.red = c;
                TreeNode<K, V> sr = s.right;
                TreeNode<K, V> pp = p2.parent;
                if (s == pr) {
                    p2.parent = s;
                    s.right = p2;
                } else {
                    TreeNode<K, V> sp = s.parent;
                    p2.parent = sp;
                    if (p2.parent != null) {
                        if (s == sp.left) {
                            sp.left = p2;
                        } else {
                            sp.right = p2;
                        }
                    }
                    if ((s.right = pr) != null) {
                        pr.parent = s;
                    }
                }
                p2.left = null;
                p2.right = sr;
                if (p2.right != null) {
                    sr.parent = p2;
                }
                if ((s.left = pl) != null) {
                    pl.parent = s;
                }
                if ((s.parent = pp) == null) {
                    root = s;
                } else if (p2 == pp.left) {
                    pp.left = s;
                } else {
                    pp.right = s;
                }
                replacement = sr != null ? sr : p2;
            } else {
                replacement = pl != null ? pl : (pr != null ? pr : p2);
            }
            if (replacement != p2) {
                replacement.parent = p2.parent;
                TreeNode<K, V> pp = replacement.parent;
                if (pp == null) {
                    root = replacement;
                    replacement.red = false;
                } else if (p2 == pp.left) {
                    pp.left = replacement;
                } else {
                    pp.right = replacement;
                }
                p2.parent = null;
                p2.right = null;
                p2.left = null;
            }
            TreeNode<K, V> treeNode = r = p2.red ? root : TreeNode.balanceDeletion(root, replacement);
            if (replacement == p2) {
                TreeNode<K, V> pp = p2.parent;
                p2.parent = null;
                if (pp != null) {
                    if (p2 == pp.left) {
                        pp.left = null;
                    } else if (p2 == pp.right) {
                        pp.right = null;
                    }
                }
            }
            if (movable) {
                TreeNode.moveRootToFront(tab, r);
            }
        }

        final void split(HashMapPrimitive<K, V> map, Node<K, V>[] tab, int index, int bit) {
            TreeNode b = this;
            TreeNode loHead = null;
            TreeNode loTail = null;
            TreeNode hiHead = null;
            TreeNode hiTail = null;
            int lc = 0;
            int hc = 0;
            TreeNode e = b;
            while (e != null) {
                TreeNode next = (TreeNode)e.next;
                e.next = null;
                if ((e.hash & bit) == 0) {
                    e.prev = loTail;
                    if (e.prev == null) {
                        loHead = e;
                    } else {
                        loTail.next = e;
                    }
                    loTail = e;
                    ++lc;
                } else {
                    e.prev = hiTail;
                    if (e.prev == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                    ++hc;
                }
                e = next;
            }
            if (loHead != null) {
                if (lc <= 6) {
                    tab[index] = loHead.untreeify(map);
                } else {
                    tab[index] = loHead;
                    if (hiHead != null) {
                        loHead.treeify(tab);
                    }
                }
            }
            if (hiHead != null) {
                if (hc <= 6) {
                    tab[index + bit] = hiHead.untreeify(map);
                } else {
                    tab[index + bit] = hiHead;
                    if (loHead != null) {
                        hiHead.treeify(tab);
                    }
                }
            }
        }

        static <K, V> TreeNode<K, V> rotateLeft(TreeNode<K, V> root, TreeNode<K, V> p2) {
            TreeNode<K, V> r;
            if (p2 != null && (r = p2.right) != null) {
                p2.right = r.left;
                TreeNode<K, V> rl = p2.right;
                if (p2.right != null) {
                    rl.parent = p2;
                }
                TreeNode<K, V> pp = r.parent = p2.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p2) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p2;
                p2.parent = r;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> rotateRight(TreeNode<K, V> root, TreeNode<K, V> p2) {
            TreeNode<K, V> l;
            if (p2 != null && (l = p2.left) != null) {
                p2.left = l.right;
                TreeNode<K, V> lr = p2.left;
                if (p2.left != null) {
                    lr.parent = p2;
                }
                TreeNode<K, V> pp = l.parent = p2.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p2) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p2;
                p2.parent = l;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> balanceInsertion(TreeNode<K, V> root, TreeNode<K, V> x) {
            x.red = true;
            while (true) {
                TreeNode<K, V> xpp;
                TreeNode<K, V> xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode<K, V> xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode<K, V> xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeNode.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode<K, V> treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeNode.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeNode.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode<K, V> treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeNode.rotateLeft(root, xpp);
            }
        }

        static <K, V> TreeNode<K, V> balanceDeletion(TreeNode<K, V> root, TreeNode<K, V> x) {
            while (x != null && x != root) {
                TreeNode<K, V> sr;
                TreeNode<K, V> sl;
                TreeNode<K, V> xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode<K, V> xpl = xp.left;
                if (xpl == x) {
                    TreeNode<K, V> xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeNode.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode<K, V> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeNode.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode<K, V> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeNode.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeNode.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode<K, V> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeNode.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode<K, V> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeNode.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <K, V> boolean checkInvariants(TreeNode<K, V> t) {
            TreeNode<K, V> tp = t.parent;
            TreeNode<K, V> tl = t.left;
            TreeNode<K, V> tr = t.right;
            TreeNode<K, V> tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeNode.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeNode.checkInvariants(tr);
        }
    }

    static class Entry<K, V>
    extends Node<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(int hash, K key, V value, Node<K, V> next) {
            super(hash, key, value, next);
        }
    }

    static final class EntrySpliterator<K, V>
    extends HashNativeSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(HashMapPrimitive<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                entrySpliterator = null;
            } else {
                this.index = mid;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            HashMapPrimitive m = this.map;
            Node<K, V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p2 = this.current;
                this.current = null;
                do {
                    if (p2 == null) {
                        p2 = tab[i++];
                        continue;
                    }
                    action.accept(p2);
                    p2 = p2.next;
                } while (p2 != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Node e = this.current;
                    this.current = this.current.next;
                    action.accept(e);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static final class ValueSpliterator<K, V>
    extends HashNativeSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(HashMapPrimitive<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                valueSpliterator = null;
            } else {
                this.index = mid;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            HashMapPrimitive m = this.map;
            Node<K, V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p2 = this.current;
                this.current = null;
                do {
                    if (p2 == null) {
                        p2 = tab[i++];
                        continue;
                    }
                    action.accept(p2.value);
                    p2 = p2.next;
                } while (p2 != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object v = this.current.value;
                    this.current = this.current.next;
                    action.accept(v);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return this.fence < 0 || this.est == this.map.size ? 64 : 0;
        }
    }

    static final class KeySpliterator<K, V>
    extends HashNativeSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(HashMapPrimitive<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                keySpliterator = null;
            } else {
                this.index = mid;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            HashMapPrimitive m = this.map;
            Node<K, V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p2 = this.current;
                this.current = null;
                do {
                    if (p2 == null) {
                        p2 = tab[i++];
                        continue;
                    }
                    action.accept(p2.key);
                    p2 = p2.next;
                } while (p2 != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object k = this.current.key;
                    this.current = this.current.next;
                    action.accept(k);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static class HashNativeSpliterator<K, V> {
        final HashMapPrimitive<K, V> map;
        Node<K, V> current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        HashNativeSpliterator(HashMapPrimitive<K, V> m, int origin, int fence, int est, int expectedModCount) {
            this.map = m;
            this.index = origin;
            this.fence = fence;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                HashMapPrimitive<K, V> m = this.map;
                this.est = m.size;
                this.expectedModCount = m.modCount;
                Node<K, V>[] tab = m.table;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            }
            return hi;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextNode().key;
        }
    }

    abstract class HashIterator {
        Node<K, V> next;
        Node<K, V> current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = HashMapPrimitive.this.modCount;
            Node<K, V>[] t = HashMapPrimitive.this.table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (t != null && HashMapPrimitive.this.size > 0) {
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<K, V> nextNode() {
            Node e = this.next;
            if (HashMapPrimitive.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.current.next;
            if (this.next == null) {
                Node<K, V>[] t = HashMapPrimitive.this.table;
                if (HashMapPrimitive.this.table != null) {
                    while (this.index < t.length && (this.next = t[this.index++]) == null) {
                    }
                }
            }
            return e;
        }

        public final void remove() {
            Node p2 = this.current;
            if (p2 == null) {
                throw new IllegalStateException();
            }
            if (HashMapPrimitive.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            HashMapPrimitive.this.removeNode(p2.hash, p2.key, null, false, false);
            this.expectedModCount = HashMapPrimitive.this.modCount;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return HashMapPrimitive.this.size;
        }

        @Override
        public final void clear() {
            HashMapPrimitive.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Node candidate = HashMapPrimitive.this.getNode(key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return HashMapPrimitive.this.removeNode(HashMapPrimitive.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(HashMapPrimitive.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMapPrimitive.this.size > 0) {
                Node<K, V>[] tab = HashMapPrimitive.this.table;
                if (HashMapPrimitive.this.table != null) {
                    int mc = HashMapPrimitive.this.modCount;
                    for (Node e : tab) {
                        while (e != null) {
                            action.accept(e);
                            e = e.next;
                        }
                    }
                    if (HashMapPrimitive.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public final int size() {
            return HashMapPrimitive.this.size;
        }

        @Override
        public final void clear() {
            HashMapPrimitive.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return HashMapPrimitive.this.containsValue(o);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return new ValueSpliterator(HashMapPrimitive.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return HashMapPrimitive.this.valuesToArray(new Object[HashMapPrimitive.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return HashMapPrimitive.this.valuesToArray(HashMapPrimitive.this.prepareArray(a));
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMapPrimitive.this.size > 0) {
                Node<K, V>[] tab = HashMapPrimitive.this.table;
                if (HashMapPrimitive.this.table != null) {
                    int mc = HashMapPrimitive.this.modCount;
                    for (Node e : tab) {
                        while (e != null) {
                            action.accept(e.value);
                            e = e.next;
                        }
                    }
                    if (HashMapPrimitive.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public final int size() {
            return HashMapPrimitive.this.size;
        }

        @Override
        public final void clear() {
            HashMapPrimitive.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return HashMapPrimitive.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return HashMapPrimitive.this.removeNode(HashMapPrimitive.hash(key), key, null, false, true) != null;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return new KeySpliterator(HashMapPrimitive.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return HashMapPrimitive.this.keysToArray(new Object[HashMapPrimitive.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return HashMapPrimitive.this.keysToArray(HashMapPrimitive.this.prepareArray(a));
        }

        @Override
        public final void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMapPrimitive.this.size > 0) {
                Node<K, V>[] tab = HashMapPrimitive.this.table;
                if (HashMapPrimitive.this.table != null) {
                    int mc = HashMapPrimitive.this.modCount;
                    for (Node e : tab) {
                        while (e != null) {
                            action.accept(e.key);
                            e = e.next;
                        }
                    }
                    if (HashMapPrimitive.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }
}

