/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.LoneLibs.config;

import dev.lone.LoneLibs.EnumUtil;
import dev.lone.LoneLibs.config.ConfigFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lonelibs.org.jetbrains.annotations.NotNull;
import lonelibs.org.jetbrains.annotations.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CustomConfigurationSection {
    public final ConfigurationSection s;

    public CustomConfigurationSection(ConfigurationSection section) {
        this.s = section;
    }

    public CustomConfigurationSection(ConfigFile config, String path) {
        this.s = config.getSection(path);
    }

    @NotNull
    public Set<String> getKeys(boolean deep) {
        return this.s.getKeys(deep);
    }

    @NotNull
    public Map<String, Object> getValues(boolean deep) {
        return this.s.getValues(deep);
    }

    public boolean contains(@NotNull String path) {
        return this.s.contains(path);
    }

    public boolean contains(@NotNull String path, boolean ignoreDefault) {
        return this.s.contains(path, ignoreDefault);
    }

    public boolean isSet(@NotNull String path) {
        return this.s.isSet(path);
    }

    @Nullable
    public String getCurrentPath() {
        return this.s.getCurrentPath();
    }

    @NotNull
    public String getName() {
        return this.s.getName();
    }

    @Nullable
    public Configuration getRoot() {
        return this.s.getRoot();
    }

    @Nullable
    public ConfigurationSection getParent() {
        return this.s.getParent();
    }

    @Nullable
    public Object get(@NotNull String path) {
        return this.s.get(path);
    }

    @Nullable
    public Object get(@NotNull String path, @Nullable Object def) {
        return this.s.get(path, def);
    }

    public void set(@NotNull String path, @Nullable Object value) {
        this.s.set(path, value);
    }

    @NotNull
    public ConfigurationSection createSection(@NotNull String path) {
        return this.s.createSection(path);
    }

    @NotNull
    public ConfigurationSection createSection(@NotNull String path, @NotNull Map<?, ?> map) {
        return this.s.createSection(path, map);
    }

    @Nullable
    public String getString(@NotNull String path) {
        return this.s.getString(path);
    }

    @Nullable
    public String getString(@NotNull String path, @Nullable String def) {
        return this.s.getString(path, def);
    }

    public boolean isString(@NotNull String path) {
        return this.s.isString(path);
    }

    public int getInt(@NotNull String path) {
        return this.s.getInt(path);
    }

    public int getInt(@NotNull String path, int def) {
        return this.s.getInt(path, def);
    }

    public boolean isInt(@NotNull String path) {
        return this.s.isInt(path);
    }

    public boolean getBoolean(@NotNull String path) {
        return this.s.getBoolean(path);
    }

    public boolean getBoolean(@NotNull String path, boolean def) {
        return this.s.getBoolean(path, def);
    }

    public boolean isBoolean(@NotNull String path) {
        return this.s.isBoolean(path);
    }

    public double getDouble(@NotNull String path) {
        return this.s.getDouble(path);
    }

    public double getDouble(@NotNull String path, double def) {
        return this.s.getDouble(path, def);
    }

    public boolean isDouble(@NotNull String path) {
        return this.s.isDouble(path);
    }

    public long getLong(@NotNull String path) {
        return this.s.getLong(path);
    }

    public long getLong(@NotNull String path, long def) {
        return this.s.getLong(path, def);
    }

    public boolean isLong(@NotNull String path) {
        return this.s.isLong(path);
    }

    @Nullable
    public List<?> getList(@NotNull String path) {
        return this.s.getList(path);
    }

    @Nullable
    public List<?> getList(@NotNull String path, @Nullable List<?> def) {
        return this.s.getList(path, def);
    }

    public boolean isList(@NotNull String path) {
        return this.s.isList(path);
    }

    @NotNull
    public List<String> getStringList(@NotNull String path) {
        return this.s.getStringList(path);
    }

    @NotNull
    public List<Integer> getIntegerList(@NotNull String path) {
        return this.s.getIntegerList(path);
    }

    @NotNull
    public List<Boolean> getBooleanList(@NotNull String path) {
        return this.s.getBooleanList(path);
    }

    @NotNull
    public List<Double> getDoubleList(@NotNull String path) {
        return this.s.getDoubleList(path);
    }

    @NotNull
    public List<Float> getFloatList(@NotNull String path) {
        return this.s.getFloatList(path);
    }

    @NotNull
    public List<Long> getLongList(@NotNull String path) {
        return this.s.getLongList(path);
    }

    @NotNull
    public List<Byte> getByteList(@NotNull String path) {
        return this.s.getByteList(path);
    }

    @NotNull
    public List<Character> getCharacterList(@NotNull String path) {
        return this.s.getCharacterList(path);
    }

    @NotNull
    public List<Short> getShortList(@NotNull String path) {
        return this.s.getShortList(path);
    }

    @NotNull
    public List<Map<?, ?>> getMapList(@NotNull String path) {
        return this.s.getMapList(path);
    }

    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz) {
        return (T)this.s.getObject(path, clazz);
    }

    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz, @Nullable T def) {
        return (T)this.s.getObject(path, clazz, def);
    }

    @Nullable
    public <T extends ConfigurationSerializable> T getSerializable(@NotNull String path, @NotNull Class<T> clazz) {
        return (T)this.s.getSerializable(path, clazz);
    }

    @Nullable
    public <T extends ConfigurationSerializable> T getSerializable(@NotNull String path, @NotNull Class<T> clazz, @Nullable T def) {
        return (T)this.s.getSerializable(path, clazz, def);
    }

    @Nullable
    public Vector getVector(@NotNull String path) {
        return this.s.getVector(path);
    }

    @Nullable
    public Vector getVector(@NotNull String path, @Nullable Vector def) {
        return this.s.getVector(path, def);
    }

    public boolean isVector(@NotNull String path) {
        return this.s.isVector(path);
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer(@NotNull String path) {
        return this.s.getOfflinePlayer(path);
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer(@NotNull String path, @Nullable OfflinePlayer def) {
        return this.s.getOfflinePlayer(path, def);
    }

    public boolean isOfflinePlayer(@NotNull String path) {
        return this.s.isOfflinePlayer(path);
    }

    @Nullable
    public ItemStack getItemStack(@NotNull String path) {
        return this.s.getItemStack(path);
    }

    @Nullable
    public ItemStack getItemStack(@NotNull String path, @Nullable ItemStack def) {
        return this.s.getItemStack(path, def);
    }

    public boolean isItemStack(@NotNull String path) {
        return this.s.isItemStack(path);
    }

    @Nullable
    public Color getColor(@NotNull String path) {
        return this.s.getColor(path);
    }

    @Nullable
    public Color getColor(@NotNull String path, @Nullable Color def) {
        return this.s.getColor(path, def);
    }

    public boolean isColor(@NotNull String path) {
        return this.s.isColor(path);
    }

    @Nullable
    public Location getLocation(@NotNull String path) {
        return this.s.getLocation(path);
    }

    @Nullable
    public Location getLocation(@NotNull String path, @Nullable Location def) {
        return this.s.getLocation(path, def);
    }

    public boolean isLocation(@NotNull String path) {
        return this.s.isLocation(path);
    }

    @Nullable
    public ConfigurationSection getConfigurationSection(@NotNull String path) {
        return this.s.getConfigurationSection(path);
    }

    public boolean isConfigurationSection(@NotNull String path) {
        return this.s.isConfigurationSection(path);
    }

    @Nullable
    public ConfigurationSection getDefaultSection() {
        return this.s.getDefaultSection();
    }

    public void addDefault(@NotNull String path, @Nullable Object value) {
        this.s.addDefault(path, value);
    }

    @NotNull
    public List<String> getComments(@NotNull String path) {
        return this.s.getComments(path);
    }

    @NotNull
    public List<String> getInlineComments(@NotNull String path) {
        return this.s.getInlineComments(path);
    }

    public void setComments(@NotNull String path, @Nullable List<String> comments) {
        this.s.setComments(path, comments);
    }

    public void setInlineComments(@NotNull String path, @Nullable List<String> comments) {
        this.s.setInlineComments(path, comments);
    }

    public <T extends Enum<T>> T getEnum(String path, Class<T> type) {
        return ConfigFile.getEnum(this.s, path, type, null);
    }

    public <T extends Enum<T>> T getEnum(String path, Class<T> type, T defaultValue) {
        return ConfigFile.getEnum(this.s, path, type, defaultValue);
    }

    public <T extends Enum<T>> T getEnum(String path, Class<T> type, T defaultValue, Consumer<String> errorCallback) {
        T t;
        String str = this.s.getString(path);
        T t2 = t = str != null ? EnumUtil.safeGet(str.toUpperCase(), type, defaultValue) : defaultValue;
        if (t == null) {
            errorCallback.accept(str);
        }
        return t;
    }

    public List<String> getKeysList(String path) {
        return this.getKeysList(path, false);
    }

    public List<String> getKeysList(String path, boolean deep) {
        ConfigurationSection tmp = this.s.getConfigurationSection(path);
        if (tmp == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(tmp.getKeys(deep));
    }

    public List<String> getKeysList(boolean deep) {
        return new ArrayList<String>(this.s.getKeys(deep));
    }

    public boolean hasKey(String path) {
        return this.s.contains(path);
    }

    public Integer getInt(@NotNull String path, Integer def) {
        if (this.hasKey(path)) {
            return this.s.getInt(path);
        }
        return def;
    }

    public float getFloat(String path, float defaultValue) {
        if (this.hasKey(path)) {
            return (float)this.s.getDouble(path);
        }
        return defaultValue;
    }

    public float getFloat(String path) {
        return this.getFloat(path, 0.0f);
    }

    public Float getFloat(String path, Float defaultValue) {
        if (this.hasKey(path)) {
            return Float.valueOf((float)this.s.getDouble(path));
        }
        return defaultValue;
    }

    public Boolean getBoolean(String path, Boolean defaultValue) {
        if (this.hasKey(path)) {
            return this.s.getBoolean(path);
        }
        return defaultValue;
    }
}

