/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.LoneLibs.config;

import dev.lone.LoneLibs.EnumUtil;
import dev.lone.LoneLibs.chat.Comp;
import dev.lone.LoneLibs.chat.Msg;
import dev.lone.LoneLibs.config.CustomConfigurationSection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.yaml.snakeyaml.parser.ParserException;

public class ConfigFile {
    private final Plugin plugin;
    private final Msg msg;
    private FileConfiguration config;
    private final String filePath;
    private final File file;
    private boolean hasDefaultFile = true;
    private boolean autoAddMissingProperties = false;
    private boolean warnIfNoDefaultFile;
    private String partialFilePath;
    private boolean valid;
    private boolean changed;

    public ConfigFile(Plugin plugin, Msg msg, boolean isPathRelativeToPluginFolder, String filePath, boolean hasDefaultFile, boolean autoAddMissingProperties, Character yamlSeparator) {
        this(plugin, msg, isPathRelativeToPluginFolder, filePath, hasDefaultFile, autoAddMissingProperties, true, yamlSeparator);
    }

    public ConfigFile(Plugin plugin, Msg msg, boolean isPathRelativeToPluginFolder, String filePath, boolean hasDefaultFile, boolean autoAddMissingProperties) {
        this(plugin, msg, isPathRelativeToPluginFolder, filePath, hasDefaultFile, autoAddMissingProperties, true);
    }

    public ConfigFile(Plugin plugin, Msg msg, boolean isPathRelativeToPluginFolder, String filePath, boolean hasDefaultFile, boolean autoAddMissingProperties, boolean warnIfNoDefaultFile) {
        this(plugin, msg, isPathRelativeToPluginFolder, filePath, hasDefaultFile, autoAddMissingProperties, warnIfNoDefaultFile, false, null);
    }

    public ConfigFile(Plugin plugin, Msg msg, boolean isPathRelativeToPluginFolder, String filePath, boolean hasDefaultFile, boolean autoAddMissingProperties, boolean warnIfNoDefaultFile, Character yamlSeparator) {
        this(plugin, msg, isPathRelativeToPluginFolder, filePath, hasDefaultFile, autoAddMissingProperties, warnIfNoDefaultFile, false, yamlSeparator);
    }

    public ConfigFile(Plugin plugin, Msg msg, boolean isPathRelativeToPluginFolder, String filePath, boolean hasDefaultFile, boolean autoAddMissingProperties, boolean warnIfNoDefaultFile, boolean completeMalformedDataStacktrace) {
        this(plugin, msg, isPathRelativeToPluginFolder, filePath, hasDefaultFile, autoAddMissingProperties, warnIfNoDefaultFile, completeMalformedDataStacktrace, null);
    }

    public ConfigFile(Plugin plugin, Msg msg, boolean isPathRelativeToPluginFolder, String filePath, boolean hasDefaultFile, boolean autoAddMissingProperties, boolean warnIfNoDefaultFile, boolean completeMalformedDataStacktrace, Character yamlSeparator) {
        this.plugin = plugin;
        this.msg = msg;
        this.warnIfNoDefaultFile = warnIfNoDefaultFile;
        if (isPathRelativeToPluginFolder) {
            this.partialFilePath = filePath;
            this.filePath = plugin.getDataFolder() + File.separator + filePath;
        } else {
            this.partialFilePath = filePath.replace(plugin.getDataFolder().getAbsolutePath(), "");
            this.filePath = filePath;
        }
        this.partialFilePath = this.partialFilePath.replace("\\", "/");
        if (!new File(this.filePath).exists()) {
            new File(this.filePath).getParentFile().mkdirs();
        }
        this.hasDefaultFile = hasDefaultFile;
        this.autoAddMissingProperties = autoAddMissingProperties;
        this.file = new File(this.filePath);
        try {
            this.config = ConfigFile.loadConfiguration(this.file, yamlSeparator);
            this.initFile();
            this.valid = true;
        }
        catch (InvalidConfigurationException | ParserException e) {
            Bukkit.getLogger().log(Level.WARNING, "Cannot load file: " + this.partialFilePath);
            if (completeMalformedDataStacktrace) {
                e.printStackTrace();
            } else {
                msg.warn("Error: " + e.getMessage());
            }
            this.valid = false;
        }
        catch (Throwable e) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load file: " + this.partialFilePath);
            e.printStackTrace();
            this.valid = false;
        }
    }

    public ConfigFile(Plugin plugin, Msg msg, boolean isPathRelativeToPluginFolder, String filePath, boolean hasDefaultFile) {
        this(plugin, msg, isPathRelativeToPluginFolder, filePath, hasDefaultFile, false, null);
    }

    public ConfigFile(Plugin plugin, Msg msg, boolean isPathRelativeToPluginFolder, String filePath, boolean hasDefaultFile, Character yamlSeparator) {
        this(plugin, msg, isPathRelativeToPluginFolder, filePath, hasDefaultFile, false, yamlSeparator);
    }

    public static YamlConfiguration loadConfiguration(File file, Character yamlSeparator) throws IOException, InvalidConfigurationException {
        Validate.notNull(file, "File cannot be null");
        YamlConfiguration config = new YamlConfiguration();
        if (yamlSeparator != null) {
            config.options().pathSeparator(yamlSeparator.charValue());
        }
        try {
            config.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return config;
    }

    private ConfigFile(Plugin plugin, Msg msg, String filePath) {
        this.plugin = plugin;
        this.msg = msg;
        this.filePath = filePath;
        this.file = new File(this.filePath);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    void initFile() {
        if (this.hasDefaultFile) {
            InputStream internalFile;
            String resourceFilePath = this.filePath.replace("plugins/" + this.plugin.getName() + "/", "").replace("plugins\\" + this.plugin.getName() + "\\", "").replace("plugins\\" + this.plugin.getName() + "/", "");
            if (!this.file.exists()) {
                internalFile = this.tryGetInternalFile(resourceFilePath);
                if (internalFile == null) {
                    return;
                }
                try {
                    FileUtils.copyInputStreamToFile(internalFile, this.file);
                }
                catch (IOException | NullPointerException e) {
                    this.msg.warn("Failed to load default file: " + resourceFilePath);
                    return;
                }
                catch (Throwable e) {
                    this.msg.error("Failed to load default file: " + resourceFilePath, e);
                    return;
                }
            }
            if (this.autoAddMissingProperties) {
                internalFile = this.tryGetInternalFile(resourceFilePath);
                if (internalFile == null) {
                    return;
                }
                YamlConfiguration c = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(internalFile, StandardCharsets.UTF_8));
                for (String k : c.getKeys(true)) {
                    if (this.config.contains(k)) continue;
                    this.config.set(k, c.get(k));
                }
                try {
                    this.config.save(this.file);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to save file: " + this.file.getAbsolutePath(), e);
                }
            }
            try {
                this.config.load(this.file);
            }
            catch (IOException | InvalidConfigurationException e) {
                throw new RuntimeException("Failed to load file: " + this.file.getAbsolutePath(), e);
            }
        }
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private InputStream tryGetInternalFile(String resourceFilePath) {
        InputStream internalFile = this.plugin.getResource(resourceFilePath);
        if (internalFile == null && this.warnIfNoDefaultFile) {
            this.msg.warn("Default file not found for: " + resourceFilePath);
        }
        return internalFile;
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getPartialFilePath() {
        return this.partialFilePath;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
        this.changed = true;
    }

    public void saveOnlyIfChanged() {
        if (!this.changed) {
            return;
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(File newLocation) {
        try {
            this.config.save(newLocation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasKey(String path) {
        return this.config.contains(path);
    }

    public void remove(String path) {
        this.config.set(path, null);
        this.changed = true;
    }

    public List<String> getKey() {
        return this.getSectionKeys("", false);
    }

    public List<String> getSectionKeys(String path) {
        return this.getSectionKeys(path, false);
    }

    public List<String> getSectionKeys(String path, boolean deep) {
        if (!this.hasKey(path)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.config.getConfigurationSection(path).getKeys(deep));
    }

    public static List<String> getSectionKeys(ConfigurationSection section) {
        return ConfigFile.getSectionKeys(section, "");
    }

    public static List<String> getSectionKeys(ConfigurationSection section, String path) {
        if (!section.contains(path)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(section.getKeys(false));
    }

    public Map<String, Object> getSectionKeysAndValues(String path) {
        if (!this.hasKey(path)) {
            return null;
        }
        return this.config.getConfigurationSection(path).getValues(false);
    }

    public Map<String, Object> getSectionKeysAndValuesDeep(String path) {
        if (!this.hasKey(path)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ConfigurationSection root = this.config.getConfigurationSection(path);
        if (root == null) {
            return null;
        }
        String separator = String.valueOf(this.config.options().pathSeparator());
        Set keys = root.getKeys(true);
        for (String key : keys) {
            Object val = root.get(key);
            if (val instanceof MemorySection) continue;
            String[] splitKey = key.split(separator);
            map.put(splitKey[splitKey.length - 1], val);
        }
        return map;
    }

    public List<Integer> getSectionIntegerValuesWithoutKeysDeep(String path) {
        if (!this.hasKey(path)) {
            return null;
        }
        ConfigurationSection root = this.config.getConfigurationSection(path);
        if (root == null) {
            return null;
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        Set keys = root.getKeys(true);
        for (String key : keys) {
            Object val = root.get(key);
            if (val instanceof MemorySection) continue;
            values.add((Integer)val);
        }
        return values;
    }

    public Object get(String path, Object defaultValue) {
        if (this.hasKey(path)) {
            return this.config.get(path);
        }
        return defaultValue;
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public String getString(String path, String defaultValue) {
        if (!this.hasKey(path)) {
            return defaultValue;
        }
        return this.config.getString(path);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public int getInt(String path, int defaultValue) {
        if (this.hasKey(path)) {
            return this.config.getInt(path);
        }
        return defaultValue;
    }

    public double getDouble(String path, double defaultValue) {
        if (this.hasKey(path)) {
            return this.config.getDouble(path);
        }
        return defaultValue;
    }

    public float getFloat(String path, float defaultValue) {
        if (this.hasKey(path)) {
            return (float)this.config.getDouble(path);
        }
        return defaultValue;
    }

    public float getFloat(String path) {
        return this.getFloat(path, 0.0f);
    }

    public Float getFloatOptional(String path, Float defaultValue) {
        if (this.hasKey(path)) {
            return Float.valueOf((float)this.config.getDouble(path));
        }
        return defaultValue;
    }

    public Float getFloatOptional(String path) {
        if (this.hasKey(path)) {
            return Float.valueOf((float)this.config.getDouble(path));
        }
        return null;
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public Boolean getBoolean(String path, Boolean defaultValue) {
        if (this.hasKey(path)) {
            return this.config.getBoolean(path);
        }
        return defaultValue;
    }

    public Material getMaterial(String path, Material defaultValue) {
        if (this.hasKey(path)) {
            return EnumUtil.safeGet(this.config.getString(path).toUpperCase(), Material.class, defaultValue);
        }
        return defaultValue;
    }

    public Material getMaterial(String path) {
        return this.getMaterial(path, null);
    }

    public List<Material> getMaterials(String path) {
        ArrayList<Material> coloredList = new ArrayList<Material>();
        ArrayList list = (ArrayList)this.config.getStringList(path);
        for (String matStr : list) {
            Material material = EnumUtil.safeGet(matStr.toUpperCase(), Material.class);
            if (material != null) {
                coloredList.add(material);
                continue;
            }
            this.msg.error("Invalid material '" + matStr + "'. File: '" + this.filePath + "'");
        }
        return coloredList;
    }

    public <T extends Enum<T>> T getEnum(String path, Class<T> type, T defaultValue) {
        String str = this.config.getString(path);
        return str != null ? EnumUtil.safeGet(str.toUpperCase(), type, defaultValue) : defaultValue;
    }

    public <T extends Enum<T>> T getEnum(String path, Class<T> type, T defaultValue, Consumer<String> errorCallback) {
        T t;
        String str = this.config.getString(path);
        T t2 = t = str != null ? EnumUtil.safeGet(str.toUpperCase(), type, defaultValue) : defaultValue;
        if (t == null) {
            errorCallback.accept(str);
        }
        return t;
    }

    public static <T extends Enum<T>> T getEnum(ConfigurationSection section, String path, Class<T> type) {
        return ConfigFile.getEnum(section, path, type, null);
    }

    public static <T extends Enum<T>> T getEnum(ConfigurationSection section, String path, Class<T> type, T defaultValue) {
        String str = section.getString(path);
        return str != null ? EnumUtil.safeGet(str.toUpperCase(), type, defaultValue) : defaultValue;
    }

    public String getColored(String path) {
        return this.getColored(path, null);
    }

    public String getColored(String path, String defaultValue) {
        if (this.hasKey(path)) {
            return this.convertColor(this.config.getString(path));
        }
        return defaultValue;
    }

    public String getStripped(String name) {
        return ChatColor.stripColor((String)this.getColored(name));
    }

    public List<String> getStrings(String path, boolean colored) {
        if (colored) {
            ArrayList<String> coloredList = new ArrayList<String>();
            try {
                ArrayList list = (ArrayList)this.config.getStringList(path);
                for (String entry : list) {
                    coloredList.add(this.convertColor(entry));
                }
            }
            catch (NullPointerException exc) {
                exc.printStackTrace();
                this.notifyMissingProperty(path);
            }
            return coloredList;
        }
        return this.config.getStringList(path);
    }

    public List<String> getStrings(String path) {
        return this.getStrings(path, false);
    }

    public ConfigurationSection getSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public CustomConfigurationSection getCustomSection(String path) {
        return new CustomConfigurationSection(this.getSection(path));
    }

    public EntityType getEntityType(String key, EntityType type, Consumer<String> failAction) {
        if (this.hasKey(key)) {
            String val = this.getString(key).toUpperCase();
            try {
                return EntityType.valueOf((String)val);
            }
            catch (Exception exc) {
                failAction.accept(val);
                return null;
            }
        }
        return type;
    }

    public char separator() {
        return this.getConfig().options().pathSeparator();
    }

    private String convertColor(String string) {
        return Comp.convertColor(string).replace("\\n", "\n");
    }

    protected void notifyMissingProperty(String path) {
        this.msg.error("MISSING FILE PROPERTY! '" + path + "' in file '" + this.filePath + "'");
    }
}

