/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.LoneLibs.chat;

import dev.lone.LoneLibs.chat.ColorLog;
import java.util.logging.Level;
import lonelibs.org.jetbrains.annotations.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Msg {
    String PREFIX = "[LoneLibs] ";
    String PREFIX_CONSOLE = "[LoneLibs] ";
    final ColorLog LOG = new ColorLog(this.PREFIX);

    public Msg(String prefix) {
        this.setPrefix(prefix, prefix);
    }

    public void setPrefix(String prefix) {
        this.PREFIX = prefix;
    }

    public void setPrefixConsole(String prefix) {
        this.PREFIX_CONSOLE = prefix;
        this.LOG.setPrefix(prefix);
    }

    public void setPrefix(String chat, String console) {
        this.PREFIX = chat;
        this.setPrefixConsole(console);
    }

    public void messageConsoleAndSender(CommandSender sender, String message) {
        this.log(message);
        if (sender != null && sender != Bukkit.getConsoleSender()) {
            sender.sendMessage(this.PREFIX + message);
        }
    }

    public void log(String message) {
        this.LOG.log(Level.INFO, message);
    }

    public void log(String error, Level level) {
        this.LOG.log(level, error);
    }

    public void error(String error) {
        if (ChatColor.stripColor((String)error).equals(error)) {
            this.LOG.log(Level.SEVERE, ChatColor.RED + error);
        } else {
            this.LOG.log(Level.SEVERE, error);
        }
    }

    public void error(String error, @Nullable Throwable e) {
        if (ChatColor.stripColor((String)error).equals(error)) {
            this.LOG.log(Level.SEVERE, ChatColor.RED + error);
        } else {
            this.LOG.log(Level.SEVERE, error);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void warn(String error) {
        if (ChatColor.stripColor((String)error).equals(error)) {
            this.LOG.log(Level.WARNING, ChatColor.YELLOW + error);
        } else {
            this.LOG.log(Level.WARNING, error);
        }
    }

    public void warn(String error, @Nullable Throwable e) {
        this.warn(error);
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void sendNoPrefix(CommandSender commandSender, String message) {
        commandSender.sendMessage(message);
    }

    public void send(Player player, String message) {
        player.sendMessage(this.PREFIX + message);
    }

    public void send(CommandSender sender, String message) {
        sender.sendMessage(this.PREFIX + message);
    }

    public void sendAllOp(String message) {
        this.log(message);
        for (Player sender : Bukkit.getOnlinePlayers()) {
            if (!sender.isOp()) continue;
            sender.sendMessage(this.PREFIX + message);
        }
    }
}

