/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.LoneLibs.chat;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import lonelibs.dev.lone.fastnbt.nms.Version;
import lonelibs.net.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import lonelibs.net.kyori.adventure.platform.bukkit.MinecraftComponentSerializerPatched;
import lonelibs.net.kyori.adventure.text.Component;
import lonelibs.net.kyori.adventure.text.TextComponent;
import lonelibs.net.kyori.adventure.text.TranslatableComponent;
import lonelibs.net.kyori.adventure.text.format.Style;
import lonelibs.net.kyori.adventure.text.format.TextColor;
import lonelibs.net.kyori.adventure.text.format.TextDecoration;
import lonelibs.net.kyori.adventure.text.minimessage.MiniMessage;
import lonelibs.net.kyori.adventure.text.minimessage.ParsingException;
import lonelibs.net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import lonelibs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import lonelibs.net.kyori.adventure.text.serializer.gson.legacyimpl.NBTLegacyHoverEventSerializer;
import lonelibs.net.kyori.adventure.text.serializer.json.JSONOptions;
import lonelibs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import lonelibs.net.kyori.option.OptionState;
import lonelibs.org.jetbrains.annotations.NotNull;
import lonelibs.org.jetbrains.annotations.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;

public class Comp {
    public static GsonComponentSerializer GSON_SERIALIZER;
    public static final MiniMessage MINIMESSAGE;
    public static TextColor WHITE;
    private static final Style ITALIC_STYLE_FALSE;
    public static Style WHITE_NORMAL_TEXT_STYLE;
    public static final String EMPTY_JSON_COMPONENT = "{\"text\":\"\"}";
    public static final DecimalFormat DECIMAL_FORMAT_MINIMAL;
    public static final DecimalFormat DECIMAL_FORMAT_ENDING_ZEROES;

    public static String legacyToJson(@NotNull String legacy) {
        return (String)GSON_SERIALIZER.serialize(Comp.text(legacy));
    }

    public static String jsonToLegacy(String json) throws JsonSyntaxException {
        return LegacyComponentSerializer.legacy('\u00a7').serialize(Comp.jsonToComponent(json));
    }

    public static String componentToJson(@NotNull Component component) {
        return (String)GSON_SERIALIZER.serialize(component);
    }

    @NotNull
    public static JsonElement componentToJsonTree(@NotNull Component component) {
        return GSON_SERIALIZER.serializeToTree(component);
    }

    @NotNull
    public static Component jsonToComponent(String json) throws JsonSyntaxException {
        if (!json.startsWith("{")) {
            return Component.text(json).style(WHITE_NORMAL_TEXT_STYLE);
        }
        return GSON_SERIALIZER.deserialize(json);
    }

    public static Object componentToNms(Component component) {
        return MinecraftComponentSerializerPatched.get().serialize(component);
    }

    @Nullable
    public static Component nmsToComponent(Object nms) {
        if (nms == null) {
            return null;
        }
        return MinecraftComponentSerializerPatched.get().deserialize(nms);
    }

    public static BaseComponent[] componentToBukkit(Component component) {
        return BungeeComponentSerializer.legacy().serialize(component);
    }

    public static Component text(String text) {
        TextComponent component = BukkitComponentSerializer.legacy().deserialize(text);
        return component.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public static Component text(String text, boolean noItalic) {
        if (!noItalic) {
            return BukkitComponentSerializer.legacy().deserialize(text);
        }
        return BukkitComponentSerializer.legacy().deserialize(text).style(ITALIC_STYLE_FALSE);
    }

    public static boolean mightBeJson(String str) {
        return str.trim().startsWith("{");
    }

    public static String convertColor(String message) {
        return message.replace("&", "\u00a7");
    }

    public static TranslatableComponent translatable(String key) {
        TranslatableComponent component = Component.translatable(key);
        return (TranslatableComponent)component.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public static @NotNull Style.Builder removePropertyIfDefault(Style style, Style.Builder builder, TextDecoration textDecoration, TextDecoration.State def) {
        if (style.decoration(textDecoration) == def) {
            return builder.decoration(textDecoration, TextDecoration.State.NOT_SET);
        }
        return builder.decoration(textDecoration, style.decoration(textDecoration));
    }

    public static Component optimize(Component component) {
        component = component.compact();
        Style style = component.style();
        Style.Builder builder = style.toBuilder();
        builder = Comp.removePropertyIfDefault(style, builder, TextDecoration.BOLD, TextDecoration.State.FALSE);
        builder = Comp.removePropertyIfDefault(style, builder, TextDecoration.UNDERLINED, TextDecoration.State.FALSE);
        builder = Comp.removePropertyIfDefault(style, builder, TextDecoration.STRIKETHROUGH, TextDecoration.State.FALSE);
        builder = Comp.removePropertyIfDefault(style, builder, TextDecoration.OBFUSCATED, TextDecoration.State.FALSE);
        return component.style(builder);
    }

    public static String legacy(Component component) {
        return LegacyComponentSerializer.legacy('\u00a7').serialize(component);
    }

    public static boolean isColored(Component component) {
        return component.color() != null;
    }

    public static String mergeLegacyToJson(String ... strs) {
        Component comp = Component.text("");
        for (String str : strs) {
            comp = comp.append(Component.text(str));
        }
        return Comp.componentToJson(comp);
    }

    public static Component minimessage(String str) {
        Component text;
        if (str.contains("&#") || str.contains("\u00a7#")) {
            str = Comp.convertColor(str);
        }
        try {
            str = Comp.convertColor(str);
            text = MINIMESSAGE.deserialize(str);
        }
        catch (ParsingException ignored) {
            text = Comp.text(str);
        }
        return text.colorIfAbsent(WHITE).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public static String round(double value, boolean trailingZeros) {
        if (trailingZeros) {
            return DECIMAL_FORMAT_ENDING_ZEROES.format(value);
        }
        return DECIMAL_FORMAT_MINIMAL.format(value);
    }

    static {
        MINIMESSAGE = MiniMessage.miniMessage();
        WHITE = TextColor.color(255, 255, 255);
        ITALIC_STYLE_FALSE = Style.style(builder -> builder.decoration(TextDecoration.ITALIC, false));
        WHITE_NORMAL_TEXT_STYLE = Style.style(builder -> {
            builder.color(WHITE);
            builder.decoration(TextDecoration.ITALIC, false);
        });
        DECIMAL_FORMAT_MINIMAL = new DecimalFormat("#.##");
        DECIMAL_FORMAT_MINIMAL.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        DECIMAL_FORMAT_ENDING_ZEROES = new DecimalFormat("0.0#");
        DECIMAL_FORMAT_ENDING_ZEROES.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        GSON_SERIALIZER = Version.isAtLeast(Version.v1_20_R3) ? GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).options(OptionState.optionState().value(JSONOptions.EMIT_RGB, Boolean.TRUE).value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.MODERN_ONLY).value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT, Boolean.TRUE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, Boolean.TRUE).value(JSONOptions.VALIDATE_STRICT_EVENTS, Boolean.TRUE).build()).build() : (Version.isAtLeast(Version.v1_16_R3) ? GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).options(OptionState.optionState().value(JSONOptions.EMIT_RGB, Boolean.TRUE).value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.BOTH).value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT, Boolean.FALSE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, Boolean.FALSE).value(JSONOptions.VALIDATE_STRICT_EVENTS, Boolean.FALSE).build()).build() : GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).downsampleColors().emitLegacyHoverEvent().options(OptionState.optionState().value(JSONOptions.EMIT_RGB, Boolean.FALSE).value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.LEGACY_ONLY).value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT, Boolean.FALSE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, Boolean.FALSE).value(JSONOptions.VALIDATE_STRICT_EVENTS, Boolean.FALSE).build()).build());
    }
}

