/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.LoneLibs.chat;

import java.awt.Color;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.fusesource.jansi.Ansi;

public class ColorLog {
    private static final Map<ChatColor, String> BUKKIT_COLORS_TO_ANSI = new EnumMap<ChatColor, String>(ChatColor.class);
    private static final ChatColor[] BUKKIT_CHAT_COLORS;
    private static final String PATTERN_HEX_STRING = "\u001b[38;2;%d;%d;%dm";
    private static final Pattern PATTERN_HEX_TRANSLATE;
    private Logger logger;
    private String prefix;

    public ColorLog() {
        this("");
    }

    public ColorLog(String prefix) {
        this.prefix = ColorLog.applyColors(prefix);
        this.logger = Bukkit.getServer() == null ? Logger.getGlobal() : Bukkit.getLogger();
    }

    public ColorLog(String prefix, Logger logger) {
        this.prefix = ColorLog.applyColors(prefix);
        this.logger = logger;
    }

    public void setPrefix(String prefix) {
        this.prefix = ColorLog.applyColors(prefix);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void log(Level level, String message) {
        this.logger.log(level, this.prefix + ColorLog.applyColors(message));
    }

    public void log(Level level, String message, Throwable e) {
        this.logger.log(level, this.prefix + ColorLog.applyColors(message), e);
    }

    private static String applyColors(String string) {
        if (!string.isEmpty()) {
            string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
            String result = ColorLog.convertHexColors(string);
            for (ChatColor color : BUKKIT_CHAT_COLORS) {
                result = result.replaceAll("(?i)" + color.toString(), BUKKIT_COLORS_TO_ANSI.getOrDefault(color, ""));
            }
            return result + Ansi.ansi().reset().toString();
        }
        return string;
    }

    private static String convertHexColors(String input) {
        Matcher matcher = PATTERN_HEX_TRANSLATE.matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String s = matcher.group().replace("\u00a7", "").replace('x', '#');
            Color color = Color.decode(s);
            int red = color.getRed();
            int blue = color.getBlue();
            int green = color.getGreen();
            String replacement = String.format(PATTERN_HEX_STRING, red, green, blue);
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    static {
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.BLACK, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.BLACK).boldOff().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.DARK_BLUE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.BLUE).boldOff().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.DARK_GREEN, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.GREEN).boldOff().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.DARK_AQUA, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.CYAN).boldOff().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.DARK_RED, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.RED).boldOff().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.DARK_PURPLE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.MAGENTA).boldOff().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.GOLD, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.YELLOW).boldOff().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.GRAY, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.WHITE).boldOff().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.DARK_GRAY, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.BLACK).bold().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.BLUE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.BLUE).bold().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.GREEN, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.GREEN).bold().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.AQUA, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.CYAN).bold().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.RED, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.RED).bold().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.LIGHT_PURPLE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.MAGENTA).bold().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.YELLOW, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.YELLOW).bold().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.WHITE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.WHITE).bold().toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.MAGIC, Ansi.ansi().a(Ansi.Attribute.BLINK_SLOW).toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.BOLD, Ansi.ansi().a(Ansi.Attribute.UNDERLINE_DOUBLE).toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.STRIKETHROUGH, Ansi.ansi().a(Ansi.Attribute.STRIKETHROUGH_ON).toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.UNDERLINE, Ansi.ansi().a(Ansi.Attribute.UNDERLINE).toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.ITALIC, Ansi.ansi().a(Ansi.Attribute.ITALIC).toString());
        BUKKIT_COLORS_TO_ANSI.put(ChatColor.RESET, Ansi.ansi().a(Ansi.Attribute.RESET).toString());
        BUKKIT_CHAT_COLORS = ChatColor.values();
        PATTERN_HEX_TRANSLATE = Pattern.compile("\u00a7x(\u00a7[A-F0-9]){6}", 2);
    }
}

