/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.LoneLibs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class Scheduler {
    private final Plugin plugin;
    private final HashMap<String, List<BukkitTask>> scheduled = new HashMap();
    private final ExecutorService exe = Executors.newCachedThreadPool();

    public Scheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    private String getCallerClassName() {
        return Thread.currentThread().getStackTrace()[3].getClassName();
    }

    public void unregisterTasks(Class<?> clazz) {
        List<BukkitTask> bukkitTasks = this.scheduled.get(clazz.getName());
        if (bukkitTasks != null) {
            ListIterator<BukkitTask> iter = bukkitTasks.listIterator();
            while (iter.hasNext()) {
                BukkitTask entry = iter.next();
                if (entry != null) {
                    entry.cancel();
                }
                iter.remove();
            }
        }
    }

    public BukkitScheduler get() {
        return Bukkit.getServer().getScheduler();
    }

    public void async(Runnable task) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, task);
    }

    public void async(Runnable task, long delayTicks) {
        Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, task, delayTicks);
    }

    public BukkitTask asyncLoop(final Consumer<BukkitRunnable> task, long delayTicks, long delay) {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                task.accept(this);
            }
        }.runTaskTimerAsynchronously(this.plugin, delayTicks, delay);
        this.scheduled.computeIfAbsent(this.getCallerClassName(), k -> new ArrayList()).add(bukkitTask);
        return bukkitTask;
    }

    public void sync(Runnable task) {
        Bukkit.getScheduler().runTask(this.plugin, task);
    }

    public void sync(Runnable task, long delayTicks) {
        Bukkit.getScheduler().runTaskLater(this.plugin, task, delayTicks);
    }

    public void delaySyncIf(Runnable task, long delayTicks, boolean b) {
        if (b) {
            Bukkit.getScheduler().runTaskLater(this.plugin, task, delayTicks);
        } else {
            task.run();
        }
    }

    public BukkitTask syncLoop(final Consumer<BukkitRunnable> task, long delayTicks, long delay) {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                task.accept(this);
            }
        }.runTaskTimer(this.plugin, delayTicks, delay);
        this.scheduled.computeIfAbsent(this.getCallerClassName(), k -> new ArrayList()).add(bukkitTask);
        return bukkitTask;
    }

    public void syncLoop(Runnable task, long delay) {
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimer(this.plugin, task, delay, delay);
        this.scheduled.computeIfAbsent(this.getCallerClassName(), k -> new ArrayList()).add(bukkitTask);
    }

    public void asyncNonBukkitIf(Runnable task, boolean b) {
        if (b) {
            this.exe.submit(task);
        } else {
            task.run();
        }
    }

    public void asyncNonBukkit(Runnable task) {
        this.exe.submit(task);
    }

    public void asyncNonBukkit(Runnable task, int delayMs) {
        this.exe.submit(() -> {
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            task.run();
        });
    }

    public void syncDelayedIf(Runnable runnable, boolean b) {
        this.syncDelayedIf(runnable, b, 0L);
    }

    public void syncDelayedIf(Runnable runnable, boolean b, long delay) {
        if (b) {
            this.sync(runnable, delay);
        } else {
            runnable.run();
        }
    }
}

