/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.LoneLibs;

import dev.lone.LoneLibs.Main;

public class LoneLibs {
    public static String getVersion() {
        return Main.inst.getDescription().getVersion();
    }

    public static CompareVersionResult compareVersion(String expectedVersion) {
        int i = LoneLibs.compareVersion(expectedVersion, LoneLibs.getVersion());
        switch (i) {
            case 1: {
                return CompareVersionResult.INSTALLED_IS_LOWER;
            }
            case -1: {
                return CompareVersionResult.INSTALLED_IS_NEWER;
            }
            case 0: {
                return CompareVersionResult.INSTALLED_IS_SAME;
            }
        }
        return CompareVersionResult.UNKNOWN;
    }

    public static boolean isCompatible(String expectedVersion) {
        CompareVersionResult compareVersionResult = LoneLibs.compareVersion(expectedVersion);
        return compareVersionResult != CompareVersionResult.UNKNOWN && compareVersionResult != CompareVersionResult.INSTALLED_IS_LOWER;
    }

    public static int compareVersion(String v1, String v2) {
        int vnum1 = 0;
        int vnum2 = 0;
        int i = 0;
        for (int j = 0; i < v1.length() || j < v2.length(); ++i, ++j) {
            while (i < v1.length() && v1.charAt(i) != '.') {
                vnum1 = vnum1 * 10 + (v1.charAt(i) - 48);
                ++i;
            }
            while (j < v2.length() && v2.charAt(j) != '.') {
                vnum2 = vnum2 * 10 + (v2.charAt(j) - 48);
                ++j;
            }
            if (vnum1 > vnum2) {
                return 1;
            }
            if (vnum2 > vnum1) {
                return -1;
            }
            vnum2 = 0;
            vnum1 = 0;
        }
        return 0;
    }

    public static enum CompareVersionResult {
        INSTALLED_IS_NEWER,
        INSTALLED_IS_LOWER,
        INSTALLED_IS_SAME,
        UNKNOWN;

    }
}

