/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.eventbus;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import me.lucko.luckperms.lib.eventbus.EventSubscriber;
import org.checkerframework.checker.nullness.qual.NonNull;

final class SubscriberRegistry<E> {
    private static final LoadingCache<Class<?>, Set<Class<?>>> CLASS_HIERARCHY = CacheBuilder.newBuilder().weakKeys().build(CacheLoader.from(key -> TypeToken.of((Class)key).getTypes().rawTypes()));
    private final SetMultimap<Class<?>, EventSubscriber<?>> subscribers = HashMultimap.create();
    private final LoadingCache<Class<?>, List<EventSubscriber<?>>> cache = CacheBuilder.newBuilder().initialCapacity(85).build(CacheLoader.from(eventClass -> {
        ArrayList<EventSubscriber> subscribers = new ArrayList<EventSubscriber>();
        Set types = (Set)CLASS_HIERARCHY.getUnchecked(eventClass);
        assert (types != null);
        Object object = this.lock;
        synchronized (object) {
            for (Class type : types) {
                subscribers.addAll(this.subscribers.get((Object)type));
            }
        }
        subscribers.sort(Comparator.comparingInt(EventSubscriber::postOrder));
        return subscribers;
    }));
    private final Object lock = new Object();

    SubscriberRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends E> void register(@NonNull Class<T> clazz, @NonNull EventSubscriber<? super T> subscriber) {
        Object object = this.lock;
        synchronized (object) {
            this.subscribers.put(clazz, subscriber);
            this.cache.invalidateAll();
        }
    }

    void unregister(@NonNull EventSubscriber<?> subscriber) {
        this.unregisterMatching(h -> h.equals(subscriber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterMatching(@NonNull Predicate<EventSubscriber<?>> predicate) {
        Object object = this.lock;
        synchronized (object) {
            boolean dirty = this.subscribers.values().removeIf(predicate);
            if (dirty) {
                this.cache.invalidateAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterAll() {
        Object object = this.lock;
        synchronized (object) {
            this.subscribers.clear();
            this.cache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull SetMultimap<Class<?>, EventSubscriber<?>> subscribers() {
        Object object = this.lock;
        synchronized (object) {
            return ImmutableSetMultimap.copyOf(this.subscribers);
        }
    }

    @NonNull List<EventSubscriber<?>> subscribers(@NonNull Class<?> clazz) {
        return (List)this.cache.getUnchecked(clazz);
    }
}

