/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.velocity;

import com.google.inject.Inject;
import com.moandjiezana.toml.Toml;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.vexsoftware.votifier.VoteHandler;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.net.VotifierServerBootstrap;
import com.vexsoftware.votifier.net.VotifierSession;
import com.vexsoftware.votifier.net.protocol.v1crypto.RSAIO;
import com.vexsoftware.votifier.net.protocol.v1crypto.RSAKeygen;
import com.vexsoftware.votifier.platform.BackendServer;
import com.vexsoftware.votifier.platform.LoggingAdapter;
import com.vexsoftware.votifier.platform.ProxyVotifierPlugin;
import com.vexsoftware.votifier.platform.scheduler.VotifierScheduler;
import com.vexsoftware.votifier.support.forwarding.ForwardingVoteSource;
import com.vexsoftware.votifier.support.forwarding.ServerFilter;
import com.vexsoftware.votifier.support.forwarding.cache.FileVoteCache;
import com.vexsoftware.votifier.support.forwarding.cache.MemoryVoteCache;
import com.vexsoftware.votifier.support.forwarding.cache.VoteCache;
import com.vexsoftware.votifier.support.forwarding.proxy.ProxyForwardingVoteSource;
import com.vexsoftware.votifier.util.IOUtil;
import com.vexsoftware.votifier.util.KeyCreator;
import com.vexsoftware.votifier.util.TokenUtil;
import com.vexsoftware.votifier.velocity.OnlineForwardPluginMessagingForwardingSource;
import com.vexsoftware.votifier.velocity.PluginMessagingForwardingSource;
import com.vexsoftware.votifier.velocity.SLF4JLogger;
import com.vexsoftware.votifier.velocity.VelocityBackendServer;
import com.vexsoftware.votifier.velocity.VelocityScheduler;
import com.vexsoftware.votifier.velocity.cmd.NVReloadCmd;
import com.vexsoftware.votifier.velocity.cmd.TestVoteCmd;
import com.vexsoftware.votifier.velocity.event.VotifierEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Plugin(id="nuvotifier", name="NuVotifier", version="2.7.3", authors={"Ichbinjoe"}, description="Safe, smart, and secure Votifier server plugin")
public class VotifierPlugin
implements VoteHandler,
ProxyVotifierPlugin {
    @Inject
    public Logger logger;
    private LoggingAdapter loggingAdapter;
    @Inject
    @DataDirectory
    public Path configDir;
    @Inject
    public ProxyServer server;
    private VotifierScheduler scheduler;
    private String version;
    private VotifierServerBootstrap bootstrap;
    private KeyPair keyPair;
    private boolean debug;
    private Map<String, Key> tokens = new HashMap<String, Key>();
    private ForwardingVoteSource forwardingMethod;

    private boolean loadAndBind() {
        boolean disablev1;
        Toml config;
        try {
            config = this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load configuration.", e);
        }
        File rsaDirectory = new File(this.configDir.toFile(), "rsa");
        try {
            if (!rsaDirectory.exists()) {
                if (!rsaDirectory.mkdir()) {
                    throw new RuntimeException("Unable to create the RSA key folder " + rsaDirectory);
                }
                this.keyPair = RSAKeygen.generate(2048);
                RSAIO.save(rsaDirectory, this.keyPair);
            } else {
                this.keyPair = RSAIO.load(rsaDirectory);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error creating or reading RSA tokens", (Throwable)ex);
            return false;
        }
        this.debug = config.contains("quiet") ? config.getBoolean("quiet") == false : config.getBoolean("debug", Boolean.valueOf(true));
        config.getTable("tokens").toMap().forEach((service, key) -> {
            if (key instanceof String) {
                this.tokens.put((String)service, KeyCreator.createKeyFrom((String)key));
                this.logger.info("Loaded token for website: " + service);
            }
        });
        String host = config.getString("host");
        int port = Math.toIntExact(config.getLong("port"));
        if (!this.debug) {
            this.logger.info("QUIET mode enabled!");
        }
        if (disablev1 = config.getBoolean("disable-v1-protocol", Boolean.valueOf(false)).booleanValue()) {
            this.logger.info("------------------------------------------------------------------------------");
            this.logger.info("Votifier protocol v1 parsing has been disabled. Most voting websites do not");
            this.logger.info("currently support the modern Votifier protocol in NuVotifier.");
            this.logger.info("------------------------------------------------------------------------------");
        }
        this.bootstrap = new VotifierServerBootstrap(host, port, this, disablev1);
        this.bootstrap.start(err -> {});
        Toml fwdCfg = config.getTable("forwarding");
        String fwdMethod = fwdCfg.getString("method", "none").toLowerCase();
        if ("none".equals(fwdMethod)) {
            this.getLogger().info("Method none selected for vote forwarding: Votes will not be forwarded to backend servers.");
        } else if ("pluginmessaging".equals(fwdMethod)) {
            Toml pmCfg = fwdCfg.getTable("pluginMessaging");
            String channel = pmCfg.getString("channel", "NuVotifier");
            String cacheMethod = pmCfg.getString("cache", "file").toLowerCase();
            MemoryVoteCache voteCache = null;
            if ("none".equals(cacheMethod)) {
                this.getLogger().info("Vote cache none selected for caching: votes that cannot be immediately delivered will be lost.");
            } else if ("memory".equals(cacheMethod)) {
                voteCache = new MemoryVoteCache(this, fwdCfg.getTable("memory-cache").getLong("cacheTime", Long.valueOf(-1L)));
                this.getLogger().info("Using in-memory cache for votes that are not able to be delivered.");
            } else if ("file".equals(cacheMethod)) {
                try {
                    voteCache = new FileVoteCache(this, this.configDir.resolve(fwdCfg.getTable("file-cache").getString("name")).toFile(), fwdCfg.getTable("file-cache").getLong("cacheTime", Long.valueOf(-1L)));
                }
                catch (IOException e) {
                    this.getLogger().error("Unload to load file cache. Votes will be lost!", (Throwable)e);
                }
            }
            int dumpRate = pmCfg.getLong("dumpRate", Long.valueOf(5L)).intValue();
            ServerFilter filter = new ServerFilter(pmCfg.getList("excludedServers", Collections.emptyList()), pmCfg.getBoolean("whitelist", Boolean.valueOf(false)));
            if (!pmCfg.getBoolean("onlySendToJoinedServer").booleanValue()) {
                try {
                    this.forwardingMethod = new PluginMessagingForwardingSource(channel, filter, this, (VoteCache)voteCache, dumpRate);
                    this.getLogger().info("Forwarding votes over PluginMessaging channel '" + channel + "' for vote forwarding!");
                }
                catch (RuntimeException e) {
                    this.getLogger().error("NuVotifier could not set up PluginMessaging for vote forwarding!", (Throwable)e);
                }
            } else {
                try {
                    String fallbackServer = pmCfg.getString("joinedServerFallback", null);
                    if (fallbackServer != null && fallbackServer.isEmpty()) {
                        fallbackServer = null;
                    }
                    this.forwardingMethod = new OnlineForwardPluginMessagingForwardingSource(channel, filter, this, voteCache, fallbackServer, dumpRate);
                    this.getLogger().info("Forwarding votes over PluginMessaging channel '" + channel + "' for vote forwarding for online players!");
                }
                catch (RuntimeException e) {
                    this.getLogger().error("NuVotifier could not set up PluginMessaging for vote forwarding!", (Throwable)e);
                }
            }
        } else if ("proxy".equals(fwdMethod)) {
            Toml serverSection = fwdCfg.getTable("proxy");
            ArrayList<ProxyForwardingVoteSource.BackendServer> serverList = new ArrayList<ProxyForwardingVoteSource.BackendServer>();
            for (String s : serverSection.toMap().keySet()) {
                InetAddress address;
                Toml section = serverSection.getTable(s);
                try {
                    address = InetAddress.getByName(section.getString("address"));
                }
                catch (UnknownHostException e) {
                    this.getLogger().info("Address " + section.getString("address") + " couldn't be looked up. Ignoring!");
                    continue;
                }
                Key token = null;
                try {
                    token = KeyCreator.createKeyFrom(section.getString("token", section.getString("key")));
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().error("An exception occurred while attempting to add proxy target '" + s + "' - maybe your token is wrong? Votes will not be forwarded to this server!", (Throwable)e);
                }
                if (token == null) continue;
                ProxyForwardingVoteSource.BackendServer server = new ProxyForwardingVoteSource.BackendServer(s, new InetSocketAddress(address, Math.toIntExact(section.getLong("port"))), token);
                serverList.add(server);
            }
            this.forwardingMethod = this.bootstrap.createForwardingSource(serverList, null);
            this.getLogger().info("Forwarding votes from this NuVotifier instance to another NuVotifier server.");
        } else {
            this.getLogger().error("No vote forwarding method '" + fwdMethod + "' known. Defaulting to noop implementation.");
        }
        return true;
    }

    void halt() {
        if (this.bootstrap != null) {
            this.bootstrap.shutdown();
            this.bootstrap = null;
        }
        if (this.forwardingMethod != null) {
            this.forwardingMethod.halt();
            this.forwardingMethod = null;
        }
    }

    public boolean reload() {
        try {
            this.halt();
        }
        catch (Exception ex) {
            this.getLogger().error("On halt, an exception was thrown. This may be fine!", (Throwable)ex);
        }
        if (this.loadAndBind()) {
            this.getLogger().info("Reload was successful.");
            return true;
        }
        try {
            this.halt();
            this.getLogger().error("On reload, there was a problem with the configuration. Votifier currently does nothing!");
        }
        catch (Exception ex) {
            this.getLogger().error("On reload, there was a problem loading, and we could not re-halt the server. Votifier is in an unstable state!", (Throwable)ex);
        }
        return false;
    }

    @Subscribe
    public void onServerStart(ProxyInitializeEvent event) {
        this.scheduler = new VelocityScheduler(this.server, this);
        this.loggingAdapter = new SLF4JLogger(this.logger);
        this.getServer().getCommandManager().register("pnvreload", (Command)new NVReloadCmd(this), new String[0]);
        this.getServer().getCommandManager().register("ptestvote", (Command)new TestVoteCmd(this), new String[0]);
        if (!this.loadAndBind()) {
            this.gracefulExit();
        }
    }

    @Subscribe
    public void onServerStop(ProxyShutdownEvent event) {
        this.halt();
        this.logger.info("Votifier disabled.");
    }

    @Subscribe
    public void onProxyReload(ProxyReloadEvent event) {
        this.reload();
    }

    public ProxyServer getServer() {
        return this.server;
    }

    private Toml loadConfig() throws IOException {
        Toml toml;
        block9: {
            if (!Files.exists(this.configDir, new LinkOption[0])) {
                Files.createDirectory(this.configDir, new FileAttribute[0]);
            }
            Path configPath = this.configDir.resolve("config.toml");
            BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);
            try {
                toml = new Toml().read((Reader)reader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    this.getLogger().info("Configuring Votifier for the first time...");
                    String cfgStr = new String(IOUtil.readAllBytes(VotifierPlugin.class.getResourceAsStream("/config.toml")), StandardCharsets.UTF_8);
                    String token = TokenUtil.newToken();
                    cfgStr = cfgStr.replace("%ip%", this.server.getBoundAddress().getAddress().getHostAddress());
                    cfgStr = cfgStr.replace("%default_token%", token);
                    this.getLogger().info("------------------------------------------------------------------------------");
                    this.getLogger().info("Assigning NuVotifier to listen on port 8192. If you are hosting BungeeCord on a");
                    this.getLogger().info("shared server please check with your hosting provider to verify that this port");
                    this.getLogger().info("is available for your use. Chances are that your hosting provider will assign");
                    this.getLogger().info("a different port, which you need to specify in config.toml.");
                    this.getLogger().info("------------------------------------------------------------------------------");
                    this.getLogger().info("Assigning NuVotifier to listen to interface 0.0.0.0. This is usually alright,");
                    this.getLogger().info("however, if you want NuVotifier to only listen to one interface for security ");
                    this.getLogger().info("reasons (or you use a shared host), you may change this in the config.toml.");
                    this.getLogger().info("------------------------------------------------------------------------------");
                    this.getLogger().info("Your default Votifier token is " + token + ".");
                    this.getLogger().info("You will need to provide this token when you submit your server to a voting");
                    this.getLogger().info("list.");
                    this.getLogger().info("------------------------------------------------------------------------------");
                    Files.copy(new ByteArrayInputStream(cfgStr.getBytes(StandardCharsets.UTF_8)), configPath, StandardCopyOption.REPLACE_EXISTING);
                    return new Toml().read(cfgStr);
                }
            }
            ((Reader)reader).close();
        }
        return toml;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void gracefulExit() {
        this.logger.error("Votifier did not initialize properly!");
    }

    @Override
    public LoggingAdapter getPluginLogger() {
        return this.loggingAdapter;
    }

    @Override
    public VotifierScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public Map<String, Key> getTokens() {
        return this.tokens;
    }

    @Override
    public KeyPair getProtocolV1Key() {
        return this.keyPair;
    }

    @Override
    public void onVoteReceived(Vote vote, VotifierSession.ProtocolVersion protocolVersion, String remoteAddress) {
        if (this.debug) {
            if (protocolVersion == VotifierSession.ProtocolVersion.ONE) {
                this.logger.info("Got a protocol v1 vote record from " + remoteAddress + " -> " + vote);
            } else {
                this.logger.info("Got a protocol v2 vote record from " + remoteAddress + " -> " + vote);
            }
        }
        this.server.getEventManager().fireAndForget((Object)new VotifierEvent(vote));
        if (this.forwardingMethod != null) {
            this.forwardingMethod.forward(vote);
        }
    }

    @Override
    public void onError(Throwable throwable, boolean alreadyHandledVote, String remoteAddress) {
        if (this.debug) {
            if (alreadyHandledVote) {
                this.logger.error("Vote processed, however an exception occurred with a vote from " + remoteAddress, throwable);
            } else {
                this.logger.error("Unable to process vote from " + remoteAddress, throwable);
            }
        } else if (!alreadyHandledVote) {
            this.logger.error("Unable to process vote from " + remoteAddress);
        }
    }

    @Override
    public Collection<BackendServer> getAllBackendServers() {
        return this.server.getAllServers().stream().map(s -> new VelocityBackendServer(this.server, (RegisteredServer)s)).collect(Collectors.toList());
    }

    @Override
    public Optional<BackendServer> getServer(String name) {
        return this.server.getServer(name).map(s -> new VelocityBackendServer(this.server, (RegisteredServer)s));
    }
}

