/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.velocity;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.vexsoftware.votifier.support.forwarding.AbstractPluginMessagingForwardingSource;
import com.vexsoftware.votifier.support.forwarding.ServerFilter;
import com.vexsoftware.votifier.support.forwarding.cache.VoteCache;
import com.vexsoftware.votifier.velocity.VelocityBackendServer;
import com.vexsoftware.votifier.velocity.VelocityUtil;
import com.vexsoftware.votifier.velocity.VotifierPlugin;

public class PluginMessagingForwardingSource
extends AbstractPluginMessagingForwardingSource {
    private final VotifierPlugin plugin;
    private final ChannelIdentifier velocityChannelId;

    public PluginMessagingForwardingSource(String channel, ServerFilter serverFilter, VotifierPlugin plugin, VoteCache cache, int dumpRate) {
        super(channel, serverFilter, plugin, cache, dumpRate);
        this.plugin = plugin;
        this.velocityChannelId = VelocityUtil.getId(channel);
        plugin.getServer().getChannelRegistrar().register(new ChannelIdentifier[]{this.velocityChannelId});
        plugin.getServer().getEventManager().register((Object)plugin, (Object)this);
    }

    @Subscribe
    public void onServerConnected(ServerConnectedEvent e) {
        this.onServerConnect(new VelocityBackendServer(this.plugin.getServer(), e.getServer()));
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent e) {
        if (e.getIdentifier().equals(this.velocityChannelId)) {
            e.setResult(PluginMessageEvent.ForwardResult.handled());
        }
    }
}

