/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.velocity;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.platform.BackendServer;
import com.vexsoftware.votifier.support.forwarding.AbstractPluginMessagingForwardingSource;
import com.vexsoftware.votifier.support.forwarding.ServerFilter;
import com.vexsoftware.votifier.support.forwarding.cache.VoteCache;
import com.vexsoftware.votifier.velocity.VelocityBackendServer;
import com.vexsoftware.votifier.velocity.VelocityUtil;
import com.vexsoftware.votifier.velocity.VotifierPlugin;
import java.util.Optional;

public final class OnlineForwardPluginMessagingForwardingSource
extends AbstractPluginMessagingForwardingSource {
    private final String fallbackServer;
    private final VotifierPlugin plugin;
    private final ChannelIdentifier velocityChannelId;

    public OnlineForwardPluginMessagingForwardingSource(String channel, ServerFilter serverFilter, VotifierPlugin plugin, VoteCache cache, String fallbackServer, int dumpRate) {
        super(channel, serverFilter, plugin, cache, dumpRate);
        this.fallbackServer = fallbackServer;
        this.plugin = plugin;
        this.velocityChannelId = VelocityUtil.getId(channel);
        plugin.getServer().getChannelRegistrar().register(new ChannelIdentifier[]{this.velocityChannelId});
        plugin.getServer().getEventManager().register((Object)plugin, (Object)this);
    }

    @Override
    public void forward(Vote v) {
        Optional fs;
        Optional p = this.plugin.getServer().getPlayer(v.getUsername());
        Optional sc = p.flatMap(Player::getCurrentServer);
        if (sc.isPresent() && this.serverFilter.isAllowed(((ServerConnection)sc.get()).getServerInfo().getName()) && this.forwardSpecific((BackendServer)new VelocityBackendServer(this.plugin.getServer(), ((ServerConnection)sc.get()).getServer()), v)) {
            if (this.plugin.isDebug()) {
                this.plugin.getPluginLogger().info("Successfully forwarded vote " + v + " to server " + ((ServerConnection)sc.get()).getServerInfo().getName());
            }
            return;
        }
        Optional optional = fs = this.fallbackServer == null ? Optional.empty() : this.plugin.getServer().getServer(this.fallbackServer);
        if (!fs.isPresent()) {
            this.attemptToAddToPlayerCache(v, v.getUsername());
        } else if (!this.forwardSpecific((BackendServer)new VelocityBackendServer(this.plugin.getServer(), (RegisteredServer)fs.get()), v)) {
            this.attemptToAddToCache(v, this.fallbackServer);
        }
    }

    @Subscribe
    public void onServerConnected(ServerConnectedEvent e) {
        VelocityBackendServer server = new VelocityBackendServer(this.plugin.getServer(), e.getServer());
        this.onServerConnect(server);
        this.handlePlayerSwitch(server, e.getPlayer().getUsername());
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent e) {
        if (e.getIdentifier().equals(this.velocityChannelId)) {
            e.setResult(PluginMessageEvent.ForwardResult.handled());
        }
    }
}

