/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.support.forwarding.proxy.client;

import com.vexsoftware.votifier.google.gson.JsonObject;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandlerContext;
import com.vexsoftware.votifier.io.netty.channel.SimpleChannelInboundHandler;
import com.vexsoftware.votifier.support.forwarding.proxy.client.VotifierResponseHandler;
import com.vexsoftware.votifier.util.GsonInst;

public class VotifierProtocol2ResponseHandler
extends SimpleChannelInboundHandler<String> {
    private final VotifierResponseHandler responseHandler;

    public VotifierProtocol2ResponseHandler(VotifierResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, String msg) {
        JsonObject object = GsonInst.gson.fromJson(msg, JsonObject.class);
        String status = object.get("status").getAsString();
        if (status.equals("ok")) {
            this.responseHandler.onSuccess();
        } else {
            this.responseHandler.onFailure(new Exception("Remote server error: " + object.get("cause").getAsString() + ": " + object.get("error").getAsString()));
        }
        ctx.close();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.responseHandler.onFailure(cause);
        ctx.close();
    }
}

