/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.support.forwarding.proxy.client;

import com.vexsoftware.votifier.io.netty.channel.ChannelHandlerContext;
import com.vexsoftware.votifier.io.netty.channel.SimpleChannelInboundHandler;
import com.vexsoftware.votifier.io.netty.handler.codec.CorruptedFrameException;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.platform.VotifierPlugin;
import com.vexsoftware.votifier.support.forwarding.proxy.client.VoteRequest;
import com.vexsoftware.votifier.support.forwarding.proxy.client.VotifierProtocol2ResponseHandler;
import com.vexsoftware.votifier.support.forwarding.proxy.client.VotifierResponseHandler;

public class VotifierProtocol2HandshakeHandler
extends SimpleChannelInboundHandler<String> {
    private final Vote toSend;
    private final VotifierResponseHandler responseHandler;
    private final VotifierPlugin nuVotifier;

    public VotifierProtocol2HandshakeHandler(Vote toSend, VotifierResponseHandler responseHandler, VotifierPlugin nuVotifier) {
        this.toSend = toSend;
        this.responseHandler = responseHandler;
        this.nuVotifier = nuVotifier;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, String s) {
        String[] handshakeContents = s.split(" ");
        if (handshakeContents.length != 3) {
            throw new CorruptedFrameException("Handshake is not valid.");
        }
        VoteRequest request = new VoteRequest(handshakeContents[2], this.toSend);
        if (this.nuVotifier.isDebug()) {
            this.nuVotifier.getPluginLogger().info("Sent request: " + request.toString());
        }
        ctx.writeAndFlush(request);
        ctx.pipeline().addLast(new VotifierProtocol2ResponseHandler(this.responseHandler));
        ctx.pipeline().remove(this);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.responseHandler.onFailure(cause);
        ctx.close();
    }
}

