/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.support.forwarding.proxy.client;

import com.vexsoftware.votifier.google.gson.JsonObject;
import com.vexsoftware.votifier.io.netty.buffer.ByteBuf;
import com.vexsoftware.votifier.io.netty.buffer.Unpooled;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandlerContext;
import com.vexsoftware.votifier.io.netty.handler.codec.MessageToByteEncoder;
import com.vexsoftware.votifier.support.forwarding.proxy.client.VoteRequest;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Mac;

public class VotifierProtocol2Encoder
extends MessageToByteEncoder<VoteRequest> {
    private static final short MAGIC = 29498;
    private final Key key;

    public VotifierProtocol2Encoder(Key key) {
        this.key = key;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, VoteRequest req, ByteBuf buf) throws Exception {
        JsonObject object = new JsonObject();
        JsonObject payloadObject = req.getVote().serialize();
        payloadObject.addProperty("challenge", req.getChallenge());
        String payload = payloadObject.toString();
        object.addProperty("payload", payload);
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(this.key);
        mac.update(payload.getBytes(StandardCharsets.UTF_8));
        String computed = Base64.getEncoder().encodeToString(mac.doFinal());
        object.addProperty("signature", computed);
        String finalMessage = object.toString();
        buf.writeShort(29498);
        buf.writeShort(finalMessage.length());
        ByteBuf messageBytes = Unpooled.copiedBuffer(finalMessage, StandardCharsets.UTF_8);
        buf.writeBytes(messageBytes);
        messageBytes.release();
    }
}

