/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.support.forwarding.proxy;

import com.vexsoftware.votifier.io.netty.bootstrap.Bootstrap;
import com.vexsoftware.votifier.io.netty.channel.ChannelInitializer;
import com.vexsoftware.votifier.io.netty.channel.socket.SocketChannel;
import com.vexsoftware.votifier.io.netty.handler.codec.DelimiterBasedFrameDecoder;
import com.vexsoftware.votifier.io.netty.handler.codec.Delimiters;
import com.vexsoftware.votifier.io.netty.handler.codec.string.StringDecoder;
import com.vexsoftware.votifier.io.netty.handler.timeout.ReadTimeoutHandler;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.platform.VotifierPlugin;
import com.vexsoftware.votifier.support.forwarding.ForwardingVoteSource;
import com.vexsoftware.votifier.support.forwarding.cache.VoteCache;
import com.vexsoftware.votifier.support.forwarding.proxy.client.VotifierProtocol2Encoder;
import com.vexsoftware.votifier.support.forwarding.proxy.client.VotifierProtocol2HandshakeHandler;
import com.vexsoftware.votifier.support.forwarding.proxy.client.VotifierResponseHandler;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ProxyForwardingVoteSource
implements ForwardingVoteSource {
    private static final int MAX_RETRIES = 5;
    private final VotifierPlugin plugin;
    private final Supplier<Bootstrap> nettyBootstrap;
    private final List<BackendServer> backendServers;
    private final VoteCache voteCache;
    private static final StringDecoder STRING_DECODER = new StringDecoder(StandardCharsets.US_ASCII);

    public ProxyForwardingVoteSource(VotifierPlugin plugin, Supplier<Bootstrap> nettyBootstrap, List<BackendServer> backendServers, VoteCache voteCache) {
        this.plugin = plugin;
        this.nettyBootstrap = nettyBootstrap;
        this.backendServers = backendServers;
        this.voteCache = voteCache;
    }

    @Override
    public void forward(Vote v) {
        for (BackendServer server : this.backendServers) {
            this.forwardVote(server, v, 0);
        }
    }

    private int fib(int t) {
        if (t <= 1) {
            return 1;
        }
        return this.fib(t - 2) + this.fib(t - 1);
    }

    private void forwardVote(final BackendServer server, final Vote v, final int tries) {
        ((Bootstrap)this.nettyBootstrap.get().handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel channel) {
                channel.pipeline().addLast(new DelimiterBasedFrameDecoder(256, true, Delimiters.lineDelimiter()));
                channel.pipeline().addLast(new ReadTimeoutHandler(5L, TimeUnit.SECONDS));
                channel.pipeline().addLast(STRING_DECODER);
                channel.pipeline().addLast(new VotifierProtocol2Encoder(server.key));
                channel.pipeline().addLast(new VotifierProtocol2HandshakeHandler(v, new VotifierResponseHandler(){

                    @Override
                    public void onSuccess() {
                        if (ProxyForwardingVoteSource.this.plugin.isDebug()) {
                            ProxyForwardingVoteSource.this.plugin.getPluginLogger().info("Successfully forwarded vote " + v + " to " + server.address + ".");
                        }
                    }

                    @Override
                    public void onFailure(Throwable error) {
                        ProxyForwardingVoteSource.this.handleFailure(server, v, error, tries);
                    }
                }, ProxyForwardingVoteSource.this.plugin));
            }
        })).connect(server.address).addListener(future -> {
            if (!future.isSuccess()) {
                this.handleFailure(server, v, future.cause(), tries);
            }
        });
    }

    private void handleFailure(BackendServer server, Vote v, Throwable cause, int tries) {
        int nextDelay = this.fib(tries + 1);
        boolean willRetry = tries < 5;
        String msg = "Unable to send vote to " + server.address + ".";
        if (willRetry) {
            msg = msg + " Will retry sending in " + nextDelay + " second(s).";
        } else if (this.voteCache == null) {
            msg = msg + " This vote will be lost!";
        } else {
            this.voteCache.addToCache(v, server.name);
        }
        if (this.plugin.isDebug()) {
            this.plugin.getPluginLogger().error(msg, cause, new Object[0]);
        } else {
            this.plugin.getPluginLogger().error(msg);
        }
        if (willRetry) {
            this.plugin.getScheduler().delayedOnPool(() -> this.forwardVote(server, v, tries + 1), nextDelay, TimeUnit.SECONDS);
        }
    }

    @Override
    public void halt() {
    }

    public static class BackendServer {
        private final String name;
        private final InetSocketAddress address;
        private final Key key;

        public BackendServer(String name, InetSocketAddress address, Key key) {
            this.name = name;
            this.address = address;
            this.key = key;
        }
    }
}

