/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.support.forwarding.cache;

import com.vexsoftware.votifier.google.gson.JsonObject;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.platform.LoggingAdapter;
import com.vexsoftware.votifier.platform.VotifierPlugin;
import com.vexsoftware.votifier.platform.scheduler.ScheduledVotifierTask;
import com.vexsoftware.votifier.support.forwarding.cache.VoteCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class MemoryVoteCache
implements VoteCache {
    private final LoggingAdapter l;
    private final long voteTTL;
    protected final Map<String, Collection<VoteWithRecordedTimestamp>> voteCache;
    protected final Map<String, Collection<VoteWithRecordedTimestamp>> playerVoteCache;
    protected final ReentrantLock cacheLock = new ReentrantLock();
    private final ScheduledVotifierTask sweepTask;

    public MemoryVoteCache(VotifierPlugin p, long voteTTL) {
        this.voteCache = new HashMap<String, Collection<VoteWithRecordedTimestamp>>();
        this.playerVoteCache = new HashMap<String, Collection<VoteWithRecordedTimestamp>>();
        this.voteTTL = voteTTL;
        this.l = p.getPluginLogger();
        this.sweepTask = p.getScheduler().repeatOnPool(this::sweep, 12, 12, TimeUnit.HOURS);
    }

    @Override
    public Collection<String> getCachedServers() {
        this.cacheLock.lock();
        try {
            Collection<String> collection = Collections.unmodifiableCollection(new ArrayList<String>(this.voteCache.keySet()));
            return collection;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public void addToCache(Vote v, String server) {
        if (server == null) {
            throw new NullPointerException();
        }
        this.cacheLock.lock();
        try {
            this.voteCache.computeIfAbsent(server, k -> new HashSet()).add(new VoteWithRecordedTimestamp(v));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public void addToCachePlayer(Vote v, String player) {
        if (player == null) {
            throw new NullPointerException();
        }
        this.cacheLock.lock();
        try {
            this.playerVoteCache.computeIfAbsent(player, k -> new HashSet()).add(new VoteWithRecordedTimestamp(v));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Vote> evictPlayer(String player) {
        if (player == null) {
            throw new NullPointerException();
        }
        this.cacheLock.lock();
        try {
            Collection<VoteWithRecordedTimestamp> playerVotes = this.playerVoteCache.remove(player);
            if (playerVotes != null) {
                HashSet<Vote> hashSet = new HashSet<Vote>(playerVotes);
                return hashSet;
            }
            Set<Vote> set = Collections.emptySet();
            return set;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Vote> evict(String server) {
        if (server == null) {
            throw new NullPointerException();
        }
        this.cacheLock.lock();
        try {
            Collection<VoteWithRecordedTimestamp> serverVotes = this.voteCache.remove(server);
            if (serverVotes != null) {
                HashSet<Vote> hashSet = new HashSet<Vote>(serverVotes);
                return hashSet;
            }
            Set<Vote> set = Collections.emptySet();
            return set;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public void sweep() {
        this.cacheLock.lock();
        try {
            this.sweep(this.voteCache);
            this.sweep(this.playerVoteCache);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private void sweep(Map<String, Collection<VoteWithRecordedTimestamp>> m) {
        for (Map.Entry<String, Collection<VoteWithRecordedTimestamp>> entry : m.entrySet()) {
            Iterator<VoteWithRecordedTimestamp> vi = entry.getValue().iterator();
            while (vi.hasNext()) {
                VoteWithRecordedTimestamp v = vi.next();
                if (!this.hasTimedOut(v)) continue;
                this.l.warn("Purging out of date vote.", v);
                vi.remove();
            }
        }
    }

    protected boolean hasTimedOut(VoteWithRecordedTimestamp v) {
        if (this.voteTTL == -1L) {
            return false;
        }
        long daysAsMillis = TimeUnit.DAYS.toMillis(this.voteTTL);
        return v.recorded + daysAsMillis < System.currentTimeMillis();
    }

    static class VoteWithRecordedTimestamp
    extends Vote {
        private final long recorded;

        VoteWithRecordedTimestamp(Vote vote) {
            super(vote);
            this.recorded = System.currentTimeMillis();
        }

        VoteWithRecordedTimestamp(JsonObject object) {
            super(object);
            this.recorded = object.has("recorded") ? object.get("recorded").getAsLong() : System.currentTimeMillis();
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = super.serialize();
            object.addProperty("recorded", this.recorded);
            return object;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VoteWithRecordedTimestamp that = (VoteWithRecordedTimestamp)o;
            return this.recorded == that.recorded;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (int)(this.recorded ^ this.recorded >>> 32);
            return result;
        }
    }
}

