/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.support.forwarding.cache;

import com.vexsoftware.votifier.google.gson.JsonArray;
import com.vexsoftware.votifier.google.gson.JsonElement;
import com.vexsoftware.votifier.google.gson.JsonObject;
import com.vexsoftware.votifier.platform.LoggingAdapter;
import com.vexsoftware.votifier.platform.VotifierPlugin;
import com.vexsoftware.votifier.platform.scheduler.ScheduledVotifierTask;
import com.vexsoftware.votifier.support.forwarding.cache.MemoryVoteCache;
import com.vexsoftware.votifier.util.GsonInst;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class FileVoteCache
extends MemoryVoteCache {
    private final LoggingAdapter l;
    private final File cacheFile;
    private final ScheduledVotifierTask saveTask;

    public FileVoteCache(VotifierPlugin plugin, File cacheFile, long voteTTL) throws IOException {
        super(plugin, voteTTL);
        this.cacheFile = cacheFile;
        this.l = plugin.getPluginLogger();
        this.load();
        this.saveTask = plugin.getScheduler().repeatOnPool(() -> {
            try {
                this.save();
            }
            catch (IOException e) {
                this.l.error("Unable to save cached votes, votes will be lost if you restart.", e, new Object[0]);
            }
        }, 3, 3, TimeUnit.MINUTES);
    }

    private static Set<String> keySet(JsonObject object) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            set.add(entry.getKey());
        }
        return set;
    }

    private void load() throws IOException {
        JsonObject object;
        try (BufferedReader reader = Files.newBufferedReader(this.cacheFile.toPath(), StandardCharsets.UTF_8);){
            object = GsonInst.gson.fromJson((Reader)reader, JsonObject.class);
            if (object == null) {
                object = new JsonObject();
            }
        }
        catch (NoSuchFileException e) {
            object = new JsonObject();
        }
        boolean resave = false;
        if (!(object.has("players") && object.has("servers") && object.has("version") && object.size() == 3)) {
            JsonObject oldObject = object;
            object = new JsonObject();
            object.add("servers", oldObject);
            object.add("players", new JsonObject());
            object.addProperty("version", 2);
            resave = true;
        }
        if (object.get("version").getAsInt() != 2) {
            throw new IllegalStateException("Could not read cache file! Unknown version '" + object.get("version").getAsInt() + "' read.");
        }
        JsonObject players = object.getAsJsonObject("players");
        JsonObject servers = object.getAsJsonObject("servers");
        for (String player : FileVoteCache.keySet(players)) {
            this.playerVoteCache.put(player, this.readVotes(players.getAsJsonArray(player)));
        }
        for (String server : FileVoteCache.keySet(servers)) {
            this.voteCache.put(server, this.readVotes(servers.getAsJsonArray(server)));
        }
        if (resave) {
            File replacementFile;
            int i = 0;
            while ((replacementFile = new File(this.cacheFile.getParentFile(), this.cacheFile.getName() + ".bak." + i)).exists()) {
                ++i;
            }
            if (!this.cacheFile.renameTo(replacementFile)) {
                this.l.error("Backup movement failed! Will not save.");
                return;
            }
            this.l.warn("Saving new vote cache format to file - backup moved to " + replacementFile.getAbsolutePath());
            this.save();
        }
    }

    private Collection<MemoryVoteCache.VoteWithRecordedTimestamp> readVotes(JsonArray voteArray) {
        HashSet<MemoryVoteCache.VoteWithRecordedTimestamp> votes = new HashSet<MemoryVoteCache.VoteWithRecordedTimestamp>(voteArray.size());
        for (int i = 0; i < voteArray.size(); ++i) {
            JsonObject voteObject = voteArray.get(i).getAsJsonObject();
            MemoryVoteCache.VoteWithRecordedTimestamp v = new MemoryVoteCache.VoteWithRecordedTimestamp(voteObject);
            if (this.hasTimedOut(v)) {
                this.l.warn("Purging out of date vote.", v);
                continue;
            }
            votes.add(v);
        }
        return votes;
    }

    public void save() throws IOException {
        JsonObject votesObject = new JsonObject();
        this.cacheLock.lock();
        try {
            votesObject.addProperty("version", 2);
            votesObject.add("players", this.serializeMap(this.playerVoteCache));
            votesObject.add("servers", this.serializeMap(this.voteCache));
        }
        finally {
            this.cacheLock.unlock();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.cacheFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            GsonInst.gson.toJson((JsonElement)votesObject, (Appendable)writer);
        }
    }

    public JsonObject serializeMap(Map<String, Collection<MemoryVoteCache.VoteWithRecordedTimestamp>> map) {
        JsonObject o = new JsonObject();
        Iterator<Map.Entry<String, Collection<MemoryVoteCache.VoteWithRecordedTimestamp>>> entryItr = map.entrySet().iterator();
        while (entryItr.hasNext()) {
            Map.Entry<String, Collection<MemoryVoteCache.VoteWithRecordedTimestamp>> entry = entryItr.next();
            JsonArray array = new JsonArray();
            Iterator<MemoryVoteCache.VoteWithRecordedTimestamp> voteItr = entry.getValue().iterator();
            while (voteItr.hasNext()) {
                MemoryVoteCache.VoteWithRecordedTimestamp vote = voteItr.next();
                if (this.hasTimedOut(vote)) {
                    this.l.warn("Purging out of date vote.", vote);
                    voteItr.remove();
                    continue;
                }
                array.add(vote.serialize());
            }
            if (entry.getValue().isEmpty()) {
                entryItr.remove();
            }
            o.add(entry.getKey(), array);
        }
        return o;
    }

    public void halt() throws IOException {
        this.saveTask.cancel();
        this.save();
    }
}

