/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.support.forwarding;

import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.platform.BackendServer;
import com.vexsoftware.votifier.platform.ProxyVotifierPlugin;
import com.vexsoftware.votifier.support.forwarding.ForwardingVoteSource;
import com.vexsoftware.votifier.support.forwarding.ServerFilter;
import com.vexsoftware.votifier.support.forwarding.cache.FileVoteCache;
import com.vexsoftware.votifier.support.forwarding.cache.VoteCache;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class AbstractPluginMessagingForwardingSource
implements ForwardingVoteSource {
    protected final ProxyVotifierPlugin plugin;
    protected final String channel;
    protected final VoteCache cache;
    protected final ServerFilter serverFilter;
    private final int dumpRate;

    public AbstractPluginMessagingForwardingSource(String channel, ServerFilter serverFilter, ProxyVotifierPlugin plugin, VoteCache cache, int dumpRate) {
        this.channel = channel;
        this.plugin = plugin;
        this.cache = cache;
        this.serverFilter = serverFilter;
        this.dumpRate = dumpRate;
    }

    protected AbstractPluginMessagingForwardingSource(String channel, ProxyVotifierPlugin plugin, VoteCache voteCache, int dumpRate) {
        this(channel, null, plugin, voteCache, dumpRate);
    }

    @Override
    public void forward(Vote v) {
        byte[] rawData = v.serialize().toString().getBytes(StandardCharsets.UTF_8);
        for (BackendServer server : this.plugin.getAllBackendServers()) {
            if (!this.serverFilter.isAllowed(server.getName())) continue;
            if (!this.forwardSpecific(server, rawData)) {
                this.attemptToAddToCache(v, server.getName());
                continue;
            }
            if (!this.plugin.isDebug()) continue;
            this.plugin.getPluginLogger().info("Successfully forwarded vote " + v + " to server " + server.getName());
        }
    }

    protected boolean forwardSpecific(BackendServer connection, Vote vote) {
        byte[] rawData = vote.serialize().toString().getBytes(StandardCharsets.UTF_8);
        return this.forwardSpecific(connection, rawData);
    }

    protected boolean forwardSpecific(BackendServer connection, Collection<Vote> votes) {
        StringBuilder data = new StringBuilder();
        for (Vote v : votes) {
            data.append(v.serialize().toString());
        }
        return this.forwardSpecific(connection, data.toString().getBytes(StandardCharsets.UTF_8));
    }

    private boolean forwardSpecific(BackendServer connection, byte[] data) {
        return connection.sendPluginMessage(this.channel, data);
    }

    @Override
    public void halt() {
        if (this.cache instanceof FileVoteCache) {
            try {
                ((FileVoteCache)this.cache).halt();
            }
            catch (IOException e) {
                this.plugin.getPluginLogger().error("Unable to save cached votes, votes will be lost.", e, new Object[0]);
            }
        }
    }

    protected void onServerConnect(BackendServer server) {
        if (this.cache == null) {
            return;
        }
        Collection<Vote> cachedVotes = this.cache.evict(server.getName());
        this.dumpVotesToServer(cachedVotes, server, "server '" + server + "'", failedVotes -> {
            for (Vote v : failedVotes) {
                this.cache.addToCache(v, server.getName());
            }
        });
    }

    protected void attemptToAddToCache(Vote v, String server) {
        if (this.cache != null) {
            this.cache.addToCache(v, server);
            if (this.plugin.isDebug()) {
                this.plugin.getPluginLogger().info("Added to forwarding cache: " + v + " -> " + server);
            }
        } else if (this.plugin.isDebug()) {
            this.plugin.getPluginLogger().error("Could not immediately send vote to backend, vote lost! " + v + " -> " + server);
        }
    }

    protected void attemptToAddToPlayerCache(Vote v, String player) {
        if (this.cache != null) {
            this.cache.addToCachePlayer(v, player);
            if (this.plugin.isDebug()) {
                this.plugin.getPluginLogger().info("Added to forwarding cache: " + v + " -> (player) " + player);
            }
        } else if (this.plugin.isDebug()) {
            this.plugin.getPluginLogger().error("Could not immediately send vote to backend, vote lost! " + v + " -> (player) " + player);
        }
    }

    private void dumpVotesToServer(Collection<Vote> cachedVotes, BackendServer target, String identifier, Consumer<Collection<Vote>> cb) {
        this.dumpVotesToServer(cachedVotes, target, identifier, 0, cb);
    }

    private void dumpVotesToServer(Collection<Vote> cachedVotes, BackendServer target, String identifier, int evictedAlready, Consumer<Collection<Vote>> cb) {
        if (!cachedVotes.isEmpty()) {
            this.plugin.getScheduler().delayedOnPool(() -> {
                int evicted = 0;
                Iterator vi = cachedVotes.iterator();
                ArrayList<Vote> chunk = new ArrayList<Vote>(this.dumpRate);
                while (vi.hasNext() && evicted < this.dumpRate) {
                    chunk.add((Vote)vi.next());
                    vi.remove();
                }
                if (this.forwardSpecific(target, chunk)) {
                    if ((evicted += chunk.size()) >= this.dumpRate && !cachedVotes.isEmpty()) {
                        this.dumpVotesToServer(cachedVotes, target, identifier, evictedAlready + evicted, cb);
                        return;
                    }
                } else {
                    cachedVotes.addAll(chunk);
                }
                if (this.plugin.isDebug()) {
                    this.plugin.getPluginLogger().info("Successfully evicted " + (evictedAlready + evicted) + " votes to " + identifier + ".");
                    if (!cachedVotes.isEmpty()) {
                        this.plugin.getPluginLogger().info("Held " + cachedVotes.size() + " votes for " + identifier + ".");
                    }
                }
                cb.accept(cachedVotes);
            }, evictedAlready == 0 ? 3 : 1, TimeUnit.SECONDS);
        } else {
            cb.accept(cachedVotes);
        }
    }

    protected void handlePlayerSwitch(BackendServer server, String playerName) {
        if (this.cache == null) {
            return;
        }
        if (!this.serverFilter.isAllowed(server.getName())) {
            return;
        }
        Collection<Vote> cachedVotes = this.cache.evictPlayer(playerName);
        this.dumpVotesToServer(cachedVotes, server, "player '" + playerName + "'", failedVotes -> {
            for (Vote v : failedVotes) {
                this.cache.addToCachePlayer(v, playerName);
            }
        });
    }
}

