/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.support.forwarding;

import com.vexsoftware.votifier.google.gson.JsonObject;
import com.vexsoftware.votifier.google.gson.JsonPrimitive;
import com.vexsoftware.votifier.google.gson.stream.JsonReader;
import com.vexsoftware.votifier.google.gson.stream.JsonToken;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.support.forwarding.ForwardedVoteListener;
import com.vexsoftware.votifier.support.forwarding.ForwardingVoteSink;
import java.io.CharArrayReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class AbstractPluginMessagingForwardingSink
implements ForwardingVoteSink {
    private final ForwardedVoteListener listener;

    public AbstractPluginMessagingForwardingSink(ForwardedVoteListener listener) {
        this.listener = listener;
    }

    public void handlePluginMessage(byte[] message) {
        String strMessage = new String(message, StandardCharsets.UTF_8);
        try (CharArrayReader reader = new CharArrayReader(strMessage.toCharArray());){
            JsonReader r = new JsonReader(reader);
            r.setLenient(true);
            while (r.peek() != JsonToken.END_DOCUMENT) {
                r.beginObject();
                JsonObject o = new JsonObject();
                while (r.hasNext()) {
                    String name = r.nextName();
                    if (r.peek() == JsonToken.NUMBER) {
                        o.add(name, new JsonPrimitive(r.nextLong()));
                        continue;
                    }
                    o.add(name, new JsonPrimitive(r.nextString()));
                }
                r.endObject();
                Vote v = new Vote(o);
                this.listener.onForward(v);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

