/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.sponge.forwarding;

import com.vexsoftware.votifier.sponge.NuVotifier;
import com.vexsoftware.votifier.support.forwarding.AbstractPluginMessagingForwardingSink;
import com.vexsoftware.votifier.support.forwarding.ForwardedVoteListener;
import java.util.Optional;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.api.network.RawDataListener;
import org.spongepowered.api.network.RemoteConnection;

public class SpongePluginMessagingForwardingSink
extends AbstractPluginMessagingForwardingSink
implements RawDataListener {
    private final NuVotifier p;
    private final ChannelBinding.RawDataChannel channelBinding;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpongePluginMessagingForwardingSink(NuVotifier p, String channel, ForwardedVoteListener listener) {
        super(listener);
        Optional binding = Sponge.getChannelRegistrar().getChannel(channel);
        if (binding.isPresent()) {
            if (!(binding.get() instanceof ChannelBinding.RawDataChannel)) throw new IllegalStateException("Found an indexed channel - this is a problem.");
            this.channelBinding = (ChannelBinding.RawDataChannel)binding.get();
        } else {
            this.channelBinding = Sponge.getChannelRegistrar().createRawChannel((Object)p, channel);
        }
        this.channelBinding.addListener(Platform.Type.SERVER, (RawDataListener)this);
        this.p = p;
    }

    @Override
    public void halt() {
        this.channelBinding.removeListener((RawDataListener)this);
    }

    public void handlePayload(ChannelBuf channelBuf, RemoteConnection remoteConnection, Platform.Type type) {
        byte[] msgDirBuf = channelBuf.readBytes(channelBuf.available());
        try {
            this.handlePluginMessage(msgDirBuf);
        }
        catch (Exception e) {
            this.p.getLogger().error("There was an unknown error when processing a forwarded vote.", (Throwable)e);
        }
    }
}

